/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dts.spell.ErrorInfo;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.event.ErrorCountListener;
import org.dts.spell.event.FindSpellCheckErrorListener;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.event.SpellCheckListener;
import org.dts.spell.finder.CharSequenceWordFinder;
import org.dts.spell.finder.Word;
import org.dts.spell.finder.WordFinder;

public class SpellChecker {
    private Set<String> ignore = new HashSet<String>();
    private Map<String, String> replace = new HashMap<String, String>();
    private boolean skipNumbers = true;
    private boolean ignoreUpperCaseWords = false;
    private boolean caseSensitive = true;
    private SpellDictionary dictionary;
    private final FindSpellCheckErrorListener ERROR_FIND_LISTENER = new FindSpellCheckErrorListener();
    private final ErrorCountListener ERROR_COUNT_LISTENER = new ErrorCountListener();
    private Word lastWord = null;

    public SpellChecker(SpellDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public void setDictionary(SpellDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public SpellDictionary getDictionary() {
        return this.dictionary;
    }

    public void addIgnore(String word) {
        this.ignore.add(word.trim());
    }

    public void resetIgnore() {
        this.ignore.clear();
    }

    public void setSkipNumbers(boolean skip) {
        this.skipNumbers = skip;
    }

    public boolean isSkipNumbers() {
        return this.skipNumbers;
    }

    public void addReplace(String oldWord, String newWord) {
        this.replace.put(oldWord.trim(), newWord.trim());
    }

    public void resetReplace() {
        this.replace.clear();
    }

    public void setCaseSensitive(boolean sensitive) {
        this.caseSensitive = sensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isIgnoreUpperCaseWords() {
        return this.ignoreUpperCaseWords;
    }

    public void setIgnoreUpperCaseWords(boolean ignore) {
        this.ignoreUpperCaseWords = ignore;
    }

    private boolean checkCase(Word word) {
        if (this.isCaseSensitive()) {
            return word.isCorrectFirstChar();
        }
        return true;
    }

    public boolean isCorrect(CharSequence txt) {
        return this.isCorrect(new CharSequenceWordFinder(txt));
    }

    public boolean isCorrect(WordFinder finder) {
        return this.check(finder, this.ERROR_FIND_LISTENER);
    }

    public Word checkSpell(CharSequence txt) {
        return this.checkSpell(new CharSequenceWordFinder(txt));
    }

    public Word checkSpell(WordFinder finder) {
        this.check(finder, this.ERROR_FIND_LISTENER);
        return this.ERROR_FIND_LISTENER.getInvalidWord();
    }

    public ErrorInfo hasSpellErrors(CharSequence txt) {
        return this.hasSpellErrors(new CharSequenceWordFinder(txt));
    }

    public ErrorInfo hasSpellErrors(WordFinder finder) {
        this.check(finder, this.ERROR_FIND_LISTENER);
        return this.ERROR_FIND_LISTENER.getErrorInfo();
    }

    public int getErrorCount(CharSequence txt) {
        return this.getErrorCount(new CharSequenceWordFinder(txt));
    }

    public int getErrorCount(WordFinder finder) {
        this.check(finder, this.ERROR_COUNT_LISTENER);
        return this.ERROR_COUNT_LISTENER.getErrorsCount();
    }

    private boolean isRepeat(Word word, Word last) {
        return null != last && last.hasLetters() && word.equalIgnoreCaseText(last) && !word.isStartOfSentence();
    }

    private boolean isNumber(Word word) {
        return !word.hasLetters();
    }

    private boolean canSkipWord(Word word) {
        return this.isNumber(word) && this.isSkipNumbers() || word.isUpperCase() && this.isIgnoreUpperCaseWords();
    }

    private SpellCheckEvent checkCurrent(Word word, Word last, WordFinder finder, SpellCheckListener listener) {
        String wordText = word.getText();
        String newString = this.replace.get(wordText);
        SpellDictionary dict = this.getDictionary();
        SpellCheckEvent event = null;
        if (null != newString) {
            finder.replace(newString);
            word = finder.current();
            wordText = newString;
        }
        if (this.isRepeat(word, last)) {
            event = new SpellCheckEvent(this, finder);
            listener.repeatWordError(event);
        } else if (!this.canSkipWord(word)) {
            if (!dict.isCorrect(wordText) && !this.ignore.contains(wordText)) {
                event = new SpellCheckEvent(this, finder);
                listener.spellingError(event);
            } else if (!this.checkCase(word)) {
                event = new SpellCheckEvent(this, finder);
                listener.badCaseError(event);
            }
        }
        return event;
    }

    public void setLastWord(Word lastWord) {
        this.lastWord = lastWord;
    }

    public boolean check(WordFinder finder, SpellCheckListener listener) {
        boolean result = true;
        SpellCheckEvent event = new SpellCheckEvent(this, finder);
        listener.beginChecking(event);
        boolean exit = event.isCancel();
        while (!exit && finder.hasNext()) {
            Word word = finder.next();
            event = this.checkCurrent(word, this.lastWord, finder, listener);
            if (null != event) {
                result = false;
                exit = event.isCancel();
            }
            this.lastWord = word;
        }
        listener.endChecking(new SpellCheckEvent(this, finder));
        this.lastWord = null;
        return result;
    }
}

