/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell;

import java.util.List;
import java.util.ResourceBundle;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;

public class ErrorInfo {
    public static int MAX_SUGGESSTIONS = 4;
    private SuggestionsLoader loader;
    private Word badWord;
    private String description;
    private String[] suggestions;
    private SpellDictionary dictionary;

    private ErrorInfo(SpellCheckEvent event) {
        this(event, null);
        this.loader = new SuggestionsLoader();
    }

    private ErrorInfo(SpellCheckEvent event, String description) {
        this.badWord = event.getCurrentWord();
        this.description = description;
        this.suggestions = null;
        this.dictionary = event.getDictionary();
    }

    private ErrorInfo(SpellCheckEvent event, String description, String suggestion) {
        this.badWord = event.getCurrentWord();
        this.description = description;
        this.suggestions = new String[]{suggestion};
        this.dictionary = event.getDictionary();
    }

    public Word getBadWord() {
        return this.badWord;
    }

    public SpellDictionary getDictionary() {
        return this.dictionary;
    }

    public synchronized String getDescription() {
        if (null == this.description) {
            this.description = this.loader.loadDescription();
        }
        return this.description;
    }

    public String getFirstSuggestion() {
        String[] sgs = this.getSuggestions();
        if (sgs.length > 0) {
            return sgs[0];
        }
        return "";
    }

    public synchronized String[] getSuggestions() {
        if (null == this.suggestions && null != this.loader) {
            this.description = this.loader.load();
            this.loader = null;
        }
        return this.suggestions;
    }

    public synchronized boolean isBadCaseError() {
        return null != this.suggestions && 1 == this.suggestions.length && this.badWord.getStartSentenceWordCase().equals(this.suggestions[0]);
    }

    public synchronized boolean isRepeatWordError() {
        return null == this.suggestions && null == this.loader;
    }

    public synchronized boolean isSpellingError() {
        return !this.isBadCaseError() && !this.isRepeatWordError();
    }

    public static ErrorInfo getBadCaseErrorInfo(SpellCheckEvent event) {
        String word = event.getCurrentWord().getText();
        return new ErrorInfo(event, String.format(ErrorInfo.getString("BAD_CASE_ERROR_INFO"), word), Word.getStartSentenceWordCase(word));
    }

    public static ErrorInfo getRepeatWordErrorInfo(SpellCheckEvent event) {
        return new ErrorInfo(event, String.format(ErrorInfo.getString("REPEAT_WORD_ERROR_INFO"), event.getCurrentWord()));
    }

    public static ErrorInfo getSpellingErrorInfo(SpellCheckEvent event) {
        return new ErrorInfo(event);
    }

    private static String getString(String key) {
        return ResourceBundle.getBundle("org/dts/spell/messages").getString(key);
    }

    static /* synthetic */ String[] access$202(ErrorInfo x0, String[] x1) {
        x0.suggestions = x1;
        return x1;
    }

    private class SuggestionsLoader {
        public String load() {
            List<String> suggentionList = ErrorInfo.this.getDictionary().getSuggestions(ErrorInfo.this.badWord.getText(), MAX_SUGGESSTIONS);
            String result = !suggentionList.isEmpty() ? String.format(ErrorInfo.getString("SPELL_ERROR_INFO"), ErrorInfo.this.badWord, suggentionList.get(0)) : String.format(ErrorInfo.getString("SPELL_NO_SUGGESTIONS_ERROR_INFO"), ErrorInfo.this.badWord);
            ErrorInfo.access$202(ErrorInfo.this, new String[suggentionList.size()]);
            suggentionList.subList(0, ErrorInfo.this.suggestions.length).toArray(ErrorInfo.this.suggestions);
            return result;
        }

        public String loadDescription() {
            List<String> suggentionList = ErrorInfo.this.getDictionary().getSuggestions(ErrorInfo.this.badWord.getText(), 1);
            String result = !suggentionList.isEmpty() ? String.format(ErrorInfo.getString("SPELL_ERROR_INFO"), ErrorInfo.this.badWord, suggentionList.get(0)) : String.format(ErrorInfo.getString("SPELL_NO_SUGGESTIONS_ERROR_INFO"), ErrorInfo.this.badWord);
            return result;
        }
    }
}

