/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.queue;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging.Logger;
import org.jitsi.utils.queue.AsyncQueueHandler;
import org.jitsi.utils.queue.ErrorHandler;
import org.jitsi.utils.queue.QueueStatistics;
import org.json.simple.JSONObject;

public abstract class PacketQueue<T> {
    private static final Logger logger = Logger.getLogger(PacketQueue.class.getName());
    private static final int DEFAULT_CAPACITY = 256;
    private static boolean enableStatisticsDefault = false;
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="We synchronize on the queue intentionally.")
    private final BlockingQueue<T> queue;
    private final boolean copy;
    private final QueueStatistics queueStatistics;
    private final AsyncQueueHandler asyncQueueHandler;
    private final String id;
    private volatile boolean closed = false;
    private final int capacity;
    @NotNull
    private ErrorHandler errorHandler = new ErrorHandler(){};

    public static void setEnableStatisticsDefault(boolean enable) {
        enableStatisticsDefault = enable;
    }

    public PacketQueue() {
        this(null, "PacketQueue", null);
    }

    public PacketQueue(Boolean enableStatistics, String id, PacketHandler<T> packetHandler) {
        this(256, true, enableStatistics, id, packetHandler);
    }

    public PacketQueue(int capacity, boolean copy, Boolean enableStatistics, String id, PacketHandler<T> packetHandler) {
        this(capacity, copy, enableStatistics, id, packetHandler, null);
    }

    public PacketQueue(int capacity, boolean copy, Boolean enableStatistics, String id, PacketHandler<T> packetHandler, ExecutorService executor) {
        this.copy = copy;
        this.id = id;
        this.capacity = capacity;
        this.queue = new ArrayBlockingQueue<T>(capacity);
        if (enableStatistics == null) {
            enableStatistics = enableStatisticsDefault;
        }
        this.queueStatistics = enableStatistics != false ? new QueueStatistics() : null;
        this.asyncQueueHandler = packetHandler != null ? new AsyncQueueHandler<T>(this.queue, new HandlerAdapter(packetHandler), id, executor, packetHandler.maxSequentiallyProcessedPackets()) : null;
        logger.debug("Initialized a PacketQueue instance with ID " + id);
    }

    public void add(byte[] buf, int off, int len) {
        this.add(buf, off, len, null);
    }

    public void add(byte[] buf, int off, int len, Object context) {
        if (this.copy) {
            byte[] newBuf = this.getByteArray(len);
            System.arraycopy(buf, off, newBuf, 0, len);
            this.doAdd(this.createPacket(newBuf, 0, len, context));
        } else {
            this.doAdd(this.createPacket(buf, off, len, context));
        }
    }

    public void add(T pkt) {
        if (this.copy) {
            this.add(this.getBuffer(pkt), this.getOffset(pkt), this.getLength(pkt), this.getContext(pkt));
        } else {
            this.doAdd(pkt);
        }
    }

    private byte[] getByteArray(int len) {
        return new byte[len];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(T pkt) {
        if (this.closed) {
            return;
        }
        while (!this.queue.offer(pkt)) {
            Object p = this.queue.poll();
            if (p == null) continue;
            if (this.queueStatistics != null) {
                this.queueStatistics.drop(System.currentTimeMillis());
            }
            this.errorHandler.packetDropped();
            this.releasePacket(p);
        }
        if (this.queueStatistics != null) {
            this.queueStatistics.add(System.currentTimeMillis());
        }
        BlockingQueue<T> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            this.queue.notify();
        }
        if (this.asyncQueueHandler != null) {
            this.asyncQueueHandler.handleQueueItemsUntilEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (this.asyncQueueHandler != null) {
            throw new IllegalStateException("Trying to read from a queue with a configured handler.");
        }
        while (!this.closed) {
            BlockingQueue<T> blockingQueue = this.queue;
            synchronized (blockingQueue) {
                Object pkt = this.queue.poll();
                if (pkt != null) {
                    if (this.queueStatistics != null) {
                        this.queueStatistics.remove(System.currentTimeMillis());
                    }
                    return (T)pkt;
                }
                try {
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll() {
        if (this.closed) {
            return null;
        }
        if (this.asyncQueueHandler != null) {
            throw new IllegalStateException("Trying to read from a queue with a configured handler.");
        }
        BlockingQueue<T> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            Object pkt = this.queue.poll();
            if (pkt != null && this.queueStatistics != null) {
                this.queueStatistics.remove(System.currentTimeMillis());
            }
            return (T)pkt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.closed) {
            Object item;
            this.closed = true;
            if (this.asyncQueueHandler != null) {
                this.asyncQueueHandler.cancel();
            }
            BlockingQueue<T> blockingQueue = this.queue;
            synchronized (blockingQueue) {
                this.queue.notifyAll();
            }
            while ((item = this.queue.poll()) != null) {
                this.releasePacket(item);
            }
        }
    }

    public abstract byte[] getBuffer(T var1);

    public abstract int getOffset(T var1);

    public abstract int getLength(T var1);

    public abstract Object getContext(T var1);

    protected abstract T createPacket(byte[] var1, int var2, int var3, Object var4);

    protected void releasePacket(T pkt) {
    }

    public JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        debugState.put((Object)"id", (Object)this.id);
        debugState.put((Object)"capacity", (Object)this.capacity);
        debugState.put((Object)"copy", (Object)this.copy);
        debugState.put((Object)"closed", (Object)this.closed);
        debugState.put((Object)"statistics", this.queueStatistics == null ? null : this.queueStatistics.getStats());
        return debugState;
    }

    public void setErrorHandler(@NotNull ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private final class HandlerAdapter
    implements AsyncQueueHandler.Handler<T> {
        private final PacketHandler<T> handler;

        HandlerAdapter(PacketHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public void handleItem(T item) {
            if (PacketQueue.this.queueStatistics != null) {
                PacketQueue.this.queueStatistics.remove(System.currentTimeMillis());
            }
            try {
                this.handler.handlePacket(item);
            }
            catch (Throwable t) {
                PacketQueue.this.errorHandler.packetHandlingFailed(t);
            }
        }
    }

    public static interface PacketHandler<T> {
        public boolean handlePacket(T var1);

        default public long maxSequentiallyProcessedPackets() {
            return -1L;
        }
    }
}

