/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.stats;

import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.stats.TimeBasedSlidingWindow;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0019\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0015\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\r\u001a\u0017\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/utils/stats/MovingAverage;", "T", "", "", "windowSize", "Ljava/time/Duration;", "clock", "Ljava/time/Clock;", "(Ljava/time/Duration;Ljava/time/Clock;)V", "currSum", "", "numElements", "", "slidingWindow", "Lorg/jitsi/utils/stats/TimeBasedSlidingWindow;", "Lkotlin/ParameterName;", "name", "value", "add", "", "(Ljava/lang/Number;)V", "get", "", "onEviction", "jitsi-utils"})
public final class MovingAverage<T extends Number> {
    private final TimeBasedSlidingWindow<T> slidingWindow;
    private long currSum;
    private int numElements;

    public final synchronized double get() {
        this.slidingWindow.forceEviction();
        if (this.numElements == 0) {
            return 0.0;
        }
        return (double)this.currSum / (double)this.numElements;
    }

    public final synchronized void add(@NotNull T value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.slidingWindow.add(value);
        this.currSum += ((Number)value).longValue();
        int n = this.numElements;
        this.numElements = n + 1;
    }

    private final synchronized void onEviction(T value) {
        this.currSum -= ((Number)value).longValue();
        int n = this.numElements;
        this.numElements = n + -1;
    }

    @JvmOverloads
    public MovingAverage(@NotNull Duration windowSize, @NotNull Clock clock) {
        Intrinsics.checkParameterIsNotNull((Object)windowSize, (String)"windowSize");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        this.slidingWindow = new TimeBasedSlidingWindow(windowSize, (Function1)new Function1<T, Unit>(this){

            public final void invoke(@NotNull T p1) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                MovingAverage.access$onEviction((MovingAverage)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MovingAverage.class);
            }

            public final String getName() {
                return "onEviction";
            }

            public final String getSignature() {
                return "onEviction(Ljava/lang/Number;)V";
            }
        }, clock);
    }

    public /* synthetic */ MovingAverage(Duration duration, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkExpressionValueIsNotNull((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        this(duration, clock);
    }

    @JvmOverloads
    public MovingAverage(@NotNull Duration windowSize) {
        this(windowSize, null, 2, null);
    }

    public static final /* synthetic */ void access$onEviction(MovingAverage $this, Number value) {
        $this.onEviction(value);
    }
}

