/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.queue;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.utils.stats.BucketStats;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jitsi/utils/queue/QueueStatistics;", "", "queueSize", "", "clock", "Ljava/time/Clock;", "(ILjava/time/Clock;)V", "getClock", "()Ljava/time/Clock;", "firstPacketAdded", "Ljava/time/Instant;", "queueLengthStats", "Lorg/jitsi/utils/stats/BucketStats;", "queueWaitStats", "stats", "Lorg/jitsi/utils/OrderedJsonObject;", "getStats", "()Lorg/jitsi/utils/OrderedJsonObject;", "totalPacketsAdded", "Ljava/util/concurrent/atomic/LongAdder;", "totalPacketsDropped", "totalPacketsRemoved", "added", "", "dropped", "removed", "waitTime", "Ljava/time/Duration;", "Companion", "jitsi-utils"})
public final class QueueStatistics {
    private final LongAdder totalPacketsAdded;
    private final LongAdder totalPacketsRemoved;
    private final LongAdder totalPacketsDropped;
    private Instant firstPacketAdded;
    private final BucketStats queueLengthStats;
    private final BucketStats queueWaitStats;
    @NotNull
    private final Clock clock;
    @JvmField
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean DEBUG;
    @JvmField
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean TRACK_TIMES;
    private static final ConcurrentHashMap<String, QueueStatistics> queueStatsById;
    private static final long[] waitBucketSizes;
    public static final Companion Companion;

    @NotNull
    public final OrderedJsonObject getStats() {
        OrderedJsonObject stats;
        block0: {
            stats = new OrderedJsonObject();
            Instant now = this.clock.instant();
            ((Map)stats).put("added", this.totalPacketsAdded.sum());
            ((Map)stats).put("removed", this.totalPacketsRemoved.sum());
            ((Map)stats).put("dropped", this.totalPacketsDropped.sum());
            Duration duration = Duration.between(this.firstPacketAdded, now);
            double duration_s = (double)duration.toNanos() / 1.0E9;
            ((Map)stats).put("duration_s", duration_s);
            double packetsRemoved = this.totalPacketsRemoved.sum();
            ((Map)stats).put("average_remove_rate_pps", packetsRemoved / duration_s);
            ((Map)stats).put("queue_size_at_remove", this.queueLengthStats.toJson());
            BucketStats bucketStats = this.queueWaitStats;
            if (bucketStats == null) break block0;
            BucketStats bucketStats2 = bucketStats;
            boolean bl = false;
            boolean bl2 = false;
            BucketStats it = bucketStats2;
            boolean bl3 = false;
            ((Map)stats).put("queue_wait_time", it.toJson());
        }
        return stats;
    }

    public final void added() {
        if (this.firstPacketAdded == null) {
            this.firstPacketAdded = this.clock.instant();
        }
        this.totalPacketsAdded.increment();
    }

    public final void removed(int queueSize, @Nullable Duration waitTime) {
        block1: {
            this.totalPacketsRemoved.increment();
            this.queueLengthStats.addValue(queueSize);
            if (waitTime == null) break block1;
            BucketStats bucketStats = this.queueWaitStats;
            if (bucketStats != null) {
                bucketStats.addValue(waitTime.toMillis());
            }
        }
    }

    public final void dropped() {
        this.totalPacketsDropped.increment();
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    public QueueStatistics(int queueSize, @NotNull Clock clock) {
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        this.clock = clock;
        this.totalPacketsAdded = new LongAdder();
        this.totalPacketsRemoved = new LongAdder();
        this.totalPacketsDropped = new LongAdder();
        this.queueLengthStats = new BucketStats(QueueStatistics.Companion.getQueueLengthBucketSizes(queueSize), "_queue_size_at_remove", "");
        this.queueWaitStats = TRACK_TIMES ? new BucketStats(waitBucketSizes, "_queue_wait_time_ms", " ms") : null;
    }

    static {
        Companion = new Companion(null);
        queueStatsById = new ConcurrentHashMap();
        waitBucketSizes = new long[]{2L, 5L, 20L, 50L, 200L, 500L, 1000L};
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J!\u0010\u0011\u001a\u00020\t2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/utils/queue/QueueStatistics$Companion;", "", "()V", "DEBUG", "", "TRACK_TIMES", "queueStatsById", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jitsi/utils/queue/QueueStatistics;", "waitBucketSizes", "", "getQueueLengthBucketSizes", "capacity", "", "getStatistics", "Lorg/jitsi/utils/OrderedJsonObject;", "globalStatsFor", "queue", "Lorg/jitsi/utils/queue/PacketQueue;", "clock", "Ljava/time/Clock;", "globalStatsFor$jitsi_utils", "jitsi-utils"})
    public static final class Companion {
        @NotNull
        public final QueueStatistics globalStatsFor$jitsi_utils(@NotNull PacketQueue<?> queue, @NotNull Clock clock) {
            Intrinsics.checkParameterIsNotNull(queue, (String)"queue");
            Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
            Object v = queueStatsById.computeIfAbsent(queue.id(), (Function)new Function<String, QueueStatistics>(queue, clock){
                final /* synthetic */ PacketQueue $queue;
                final /* synthetic */ Clock $clock;

                @NotNull
                public final QueueStatistics apply(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return new QueueStatistics(this.$queue.capacity(), this.$clock);
                }
                {
                    this.$queue = packetQueue;
                    this.$clock = clock;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"queueStatsById.computeIf\u2026acity(), clock)\n        }");
            return (QueueStatistics)v;
        }

        @NotNull
        public final OrderedJsonObject getStatistics() {
            OrderedJsonObject orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            boolean bl2 = false;
            OrderedJsonObject $this$apply = orderedJsonObject;
            boolean bl3 = false;
            Set set = queueStatsById.entrySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"queueStatsById.entries");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl4 = false;
                Object k = it.getKey();
                Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
                $this$apply.put(k, ((QueueStatistics)it.getValue()).getStats());
            }
            return orderedJsonObject;
        }

        private final long[] getQueueLengthBucketSizes(int capacity) {
            long threeQuarters;
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(0L);
            for (long i = 1L; i < (long)capacity; i *= (long)4) {
                list.add(i);
            }
            long half = capacity / 2;
            if (half > ((Number)CollectionsKt.last((List)list)).longValue()) {
                list.add(half);
            }
            if ((threeQuarters = (long)(capacity * 3 / 4)) > ((Number)CollectionsKt.last((List)list)).longValue()) {
                list.add(threeQuarters);
            }
            return CollectionsKt.toLongArray((Collection)list);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

