/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.queue;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging.Logger;
import org.jitsi.utils.queue.AsyncQueueHandler;
import org.jitsi.utils.queue.ErrorHandler;
import org.jitsi.utils.queue.QueueStatistics;
import org.json.simple.JSONObject;

public class PacketQueue<T> {
    private static final Logger logger = Logger.getLogger(PacketQueue.class.getName());
    private static boolean enableStatisticsDefault = false;
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="We synchronize on the queue intentionally.")
    @NotNull
    private final BlockingQueue<T> queue;
    private final QueueStatistics queueStatistics;
    @NotNull
    private final AsyncQueueHandler<T> asyncQueueHandler;
    @NotNull
    private final String id;
    private volatile boolean closed = false;
    private final int capacity;
    @NotNull
    private ErrorHandler errorHandler = new ErrorHandler(){};

    public static void setEnableStatisticsDefault(boolean enable) {
        enableStatisticsDefault = enable;
    }

    public static boolean getEnableStatisticsDefault() {
        return enableStatisticsDefault;
    }

    public PacketQueue(int capacity, Boolean enableStatistics, @NotNull String id, @NotNull PacketHandler<T> packetHandler, ExecutorService executor) {
        this.id = id;
        this.capacity = capacity;
        this.queue = new ArrayBlockingQueue<T>(capacity);
        if (enableStatistics == null) {
            enableStatistics = enableStatisticsDefault;
        }
        this.queueStatistics = enableStatistics != false ? new QueueStatistics() : null;
        this.asyncQueueHandler = new AsyncQueueHandler<T>(this.queue, new HandlerAdapter(packetHandler), id, executor, packetHandler.maxSequentiallyProcessedPackets());
        logger.debug("Initialized a PacketQueue instance with ID " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T pkt) {
        if (this.closed) {
            return;
        }
        while (!this.queue.offer(pkt)) {
            Object p = this.queue.poll();
            if (p == null) continue;
            if (this.queueStatistics != null) {
                this.queueStatistics.drop(System.currentTimeMillis());
            }
            this.errorHandler.packetDropped();
            this.releasePacket(p);
        }
        if (this.queueStatistics != null) {
            this.queueStatistics.add(System.currentTimeMillis());
        }
        BlockingQueue<T> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            this.queue.notify();
        }
        this.asyncQueueHandler.handleQueueItemsUntilEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.closed) {
            Object item;
            this.closed = true;
            this.asyncQueueHandler.cancel();
            BlockingQueue<T> blockingQueue = this.queue;
            synchronized (blockingQueue) {
                this.queue.notifyAll();
            }
            while ((item = this.queue.poll()) != null) {
                this.releasePacket(item);
            }
        }
    }

    protected void releasePacket(T pkt) {
    }

    public JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        debugState.put((Object)"id", (Object)this.id);
        debugState.put((Object)"capacity", (Object)this.capacity);
        debugState.put((Object)"closed", (Object)this.closed);
        debugState.put((Object)"statistics", this.queueStatistics == null ? null : this.queueStatistics.getStats());
        return debugState;
    }

    public void setErrorHandler(@NotNull ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private final class HandlerAdapter
    implements AsyncQueueHandler.Handler<T> {
        private final PacketHandler<T> handler;

        HandlerAdapter(PacketHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public void handleItem(T item) {
            if (PacketQueue.this.queueStatistics != null) {
                PacketQueue.this.queueStatistics.remove(System.currentTimeMillis());
            }
            try {
                this.handler.handlePacket(item);
            }
            catch (Throwable t) {
                PacketQueue.this.errorHandler.packetHandlingFailed(t);
            }
        }
    }

    public static interface PacketHandler<T> {
        public boolean handlePacket(T var1);

        default public long maxSequentiallyProcessedPackets() {
            return -1L;
        }
    }
}

