/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rest.prometheus;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.MetricsContainer;

@Path(value="/metrics")
public class Prometheus {
    @NotNull
    private final MetricsContainer metricsContainer;

    public Prometheus(@NotNull MetricsContainer metricsContainer) {
        this.metricsContainer = metricsContainer;
    }

    @GET
    @Produces(value={"text/plain; version=0.0.4; charset=utf-8"})
    public String getPrometheusPlainText() {
        return this.metricsContainer.getPrometheusMetrics("text/plain; version=0.0.4; charset=utf-8");
    }

    @GET
    @Produces(value={"application/openmetrics-text; version=1.0.0; charset=utf-8"})
    public String getPrometheusOpenMetrics() {
        return this.metricsContainer.getPrometheusMetrics("application/openmetrics-text; version=1.0.0; charset=utf-8");
    }

    @GET
    @Produces(value={"application/json", "*/*;q=0"})
    public String getJsonString() {
        return this.metricsContainer.getJsonString();
    }
}

