/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc.internal;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.jdice.calc.AbstractCalculator;
import org.jdice.calc.CalculatorException;
import org.jdice.calc.Num;
import org.jdice.calc.Operator;
import org.jdice.calc.Step;
import org.jdice.calc.extension.AddOperator;
import org.jdice.calc.extension.SubOperator;
import org.jdice.calc.internal.Bracket;
import org.jdice.calc.internal.CList;
import org.jdice.calc.internal.FunctionData;
import org.jdice.calc.internal.InfixParser;

public class PostfixCalculator {
    private Stack<Object> stack = new Stack();
    private CList postfix = new CList();
    private int bCount = 0;
    LinkedList<Object> step = null;
    private LinkedList<Step> steps = null;

    public void toPostfix(CList infix) {
        Iterator<Object> it = infix.iterator();
        while (it.hasNext()) {
            Object current = it.next();
            if (current instanceof Operator || current instanceof Bracket) {
                if (current instanceof Bracket) {
                    Bracket bracket = (Bracket)((Object)current);
                    if (bracket == Bracket.OPEN) {
                        ++this.bCount;
                    } else if (bracket == Bracket.CLOSE) {
                        --this.bCount;
                    }
                }
                int currentPriority = this.getPriority(current);
                if (this.stack.size() == 0) {
                    this.stack.push(current);
                    continue;
                }
                if (this.stack.size() > 0 && Bracket.CLOSE.equals(current)) {
                    while (this.stack.size() > 0 && !Bracket.OPEN.equals(this.stack.peek())) {
                        this.postfix.add((Operator)this.stack.pop());
                    }
                    this.stack.pop();
                    continue;
                }
                if (this.stack.size() <= 0) continue;
                if (Bracket.OPEN.equals(current) && Bracket.OPEN.equals(this.stack.peek()) || !Bracket.OPEN.equals(current) && this.getPriority(this.stack.peek()) >= currentPriority) {
                    while (this.stack.size() > 0 && !Bracket.OPEN.equals(this.stack.peek()) && this.getPriority(this.stack.peek()) >= currentPriority) {
                        Object o = this.stack.pop();
                        if (!(o instanceof Operator)) continue;
                        this.postfix.add((Operator)o);
                    }
                    this.stack.push(current);
                    continue;
                }
                if (this.getPriority(this.stack.peek()) >= currentPriority) continue;
                this.stack.push(current);
                continue;
            }
            if (current instanceof Num) {
                Num calcValue = (Num)current;
                this.postfix.add(calcValue);
                continue;
            }
            if (!(current instanceof FunctionData)) continue;
            FunctionData calcValue = (FunctionData)current;
            this.postfix.add(calcValue);
        }
        this.popAll();
        this.missingBracketDetection(infix);
    }

    private int getPriority(Object input) {
        Bracket inputBracket = input instanceof Bracket ? (Bracket)((Object)input) : null;
        Operator inputOperation = input instanceof Operator ? (Operator)input : null;
        int priority = inputBracket != null ? inputBracket.getPriority() : inputOperation.getPriority();
        return priority;
    }

    private void popAll() {
        Enumeration e = this.stack.elements();
        while (e.hasMoreElements()) {
            Bracket peekBracket;
            Object peek = this.stack.peek();
            Bracket bracket = peekBracket = peek instanceof Bracket ? (Bracket)((Object)peek) : null;
            if (peekBracket != null) {
                this.stack.pop();
                continue;
            }
            this.postfix.add((Operator)this.stack.pop());
        }
    }

    public CList getPostfix() {
        return this.postfix;
    }

    public Num calculate(AbstractCalculator calc, CList postfix) {
        return this.calculate(calc, postfix, false);
    }

    public Num calculate(AbstractCalculator calc, CList postfix, boolean trackSteps) {
        try {
            return this.calculation(calc, postfix, trackSteps);
        }
        catch (Exception e) {
            if (!trackSteps) {
                try {
                    this.calculation(calc, postfix, true);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            StringBuilder sb = new StringBuilder();
            if (this.steps != null) {
                int count = 0;
                int sSize = this.steps.size();
                for (Step s : this.steps) {
                    sb.append(s);
                    if (++count >= sSize) {
                        sb.append("  <--- OK\n");
                        continue;
                    }
                    sb.append("\n");
                }
                Step es = this.trackStep(this.step);
                sb.append(es + "  <--- Error: " + e.getMessage());
            }
            throw new CalculatorException("Error during calculation. Check if expression is correct: " + calc.getInfix() + "\n" + sb.toString(), e);
        }
    }

    private Num calculation(AbstractCalculator calc, CList postfix, boolean trackSteps) {
        if (trackSteps) {
            this.steps = new LinkedList();
        }
        Stack<Object> values = new Stack<Object>();
        Iterator<Object> e = postfix.iterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (o instanceof Num) {
                Num value = (Num)o;
                values.push(value);
                continue;
            }
            if (o instanceof FunctionData) {
                FunctionData function = (FunctionData)o;
                values.push(function);
                continue;
            }
            if (!(o instanceof Operator)) continue;
            if (trackSteps) {
                this.step = new LinkedList();
            }
            Operator operator = (Operator)o;
            Num left = null;
            Num right = null;
            Object oRight = null;
            try {
                oRight = values.pop();
            }
            catch (Exception eR) {
                throw new CalculatorException("Missing right operand");
            }
            Num oLeft = null;
            try {
                oLeft = (Num)values.pop();
            }
            catch (Exception eL) {
                if (operator instanceof SubOperator || operator instanceof AddOperator) {
                    oLeft = new Num(0);
                }
                throw new CalculatorException("Missing operand to the left of the operator '" + operator.getSymbol() + "'");
            }
            if (oLeft instanceof FunctionData) {
                FunctionData fLeft = (FunctionData)((Object)oLeft);
                this.trackStep(this.step, fLeft);
                left = fLeft.calculate(calc);
                this.trackStep(this.step, ":", left, null);
            } else {
                left = oLeft;
                this.trackStep(this.step, left);
            }
            this.trackStep(this.step, operator);
            if (oRight instanceof FunctionData) {
                FunctionData fRight = oRight;
                this.trackStep(this.step, fRight);
                right = fRight.calculate(calc);
                this.trackStep(this.step, ":", right, null);
            } else {
                right = oRight;
                this.trackStep(this.step, right);
            }
            Num result = null;
            try {
                result = operator.calc(calc, left, right);
            }
            catch (Exception e1) {
                throw new CalculatorException(calc, "Error during calculation.", e1);
            }
            if (result == null) {
                result = new Num();
            }
            this.trackStep(this.step, "\t = ", result, "");
            values.push(result);
            if (this.steps == null) continue;
            this.steps.add(this.trackStep(this.step));
        }
        Object oResult = values.pop();
        Num result = null;
        if (oResult instanceof Num) {
            result = (Num)oResult;
        } else if (oResult instanceof FunctionData) {
            FunctionData fd = (FunctionData)oResult;
            result = fd.calculate(calc);
        }
        if (trackSteps) {
            calc.setSteps(this.steps);
        }
        result.getProperties().load(calc.getProperties());
        return result;
    }

    private Step trackStep(LinkedList<Object> step) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbDetail = new StringBuilder();
        if (step != null) {
            for (Object e : step) {
                if (e instanceof Num) {
                    Num d = (Num)e;
                    sbDetail.append("[" + d.getProperties().toString() + "] " + d.toString());
                    sb.append(d.toString());
                    continue;
                }
                if (e instanceof FunctionData) {
                    FunctionData fd = (FunctionData)e;
                    sbDetail.append(fd.toStringWithDetail());
                    sb.append(fd.toString());
                    continue;
                }
                if (e instanceof Operator) {
                    Operator op = (Operator)e;
                    sb.append("\t" + op.getSymbol() + "  ");
                    continue;
                }
                if (e instanceof String) {
                    String s = (String)e;
                    sb.append(s);
                    continue;
                }
                sb.append(e.toString());
            }
        }
        return new Step(sb.toString(), sbDetail.toString());
    }

    private void trackStep(LinkedList<Object> step, Object o) {
        this.trackStep(step, null, o, null);
    }

    private void trackStep(LinkedList<Object> step, String before, Object o, String after) {
        if (step != null) {
            if (before != null && before.length() != 0) {
                step.add(before);
            }
            step.add(o);
            if (after != null && after.length() != 0) {
                step.add(after);
            }
        }
    }

    private void missingBracketDetection(CList infix) throws CalculatorException {
        if (this.bCount > 0) {
            throw new CalculatorException("To many open bracket. " + InfixParser.toString(infix));
        }
        if (this.bCount < 0) {
            throw new CalculatorException("To many close bracket. " + InfixParser.toString(infix));
        }
    }
}

