/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jdice.calc.CalculatorException;
import org.jdice.calc.Function;
import org.jdice.calc.NumConverter;
import org.jdice.calc.Operator;
import org.jdice.calc.Properties;
import org.jdice.calc.SingletonExtension;
import org.jdice.calc.internal.UseExtension;

public class CacheExtension {
    private static volatile UseExtension cacheData = new UseExtension();
    private static volatile HashMap<Class, NumConverter> converterCache = new HashMap();
    private static volatile boolean numConverterPropLoaded = false;

    public static void setOperator(Class<? extends Operator> operatorClass) {
        cacheData.registerOperator(operatorClass);
    }

    public static HashMap<String, Class<? extends Operator>> getOperatorSymbols() {
        return cacheData.getOperatorSymbols();
    }

    public static Operator getOperator(Class<? extends Operator> operatorClass) {
        return cacheData.getOperator(operatorClass);
    }

    public static Operator getOperator(String operator) {
        return cacheData.getOperator(operator);
    }

    public static HashMap<Class<? extends Operator>, Operator> getOperators() {
        return cacheData.getOperators();
    }

    public static void setFunction(Class<? extends Function> functionClass) {
        cacheData.registerFunction(functionClass);
    }

    public static HashMap<String, Class<? extends Function>> getFunctionSymbols() {
        return cacheData.getFunctionSymbols();
    }

    public static Function getFunction(String function) {
        return cacheData.getFunction(function);
    }

    public static Function getFunction(Class<? extends Function> functionClass) {
        return cacheData.getFunction(functionClass);
    }

    public static HashMap<Class<? extends Function>, Function> getFunctions() {
        return cacheData.getFunctions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNumConverter(Class customClass, Class<? extends NumConverter> converterClass) {
        NumConverter nc = converterCache.get(customClass);
        if (nc == null) {
            Class<? extends NumConverter> clazz = converterClass;
            synchronized (clazz) {
                nc = converterCache.get(customClass);
                if (nc == null) {
                    try {
                        nc = converterClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new CalculatorException(e);
                    }
                    if (nc != null && converterClass.isAnnotationPresent(SingletonExtension.class)) {
                        converterCache.put(customClass, nc);
                    }
                }
            }
        }
    }

    public static NumConverter setNumConverter(Class customClass, NumConverter converter) {
        converterCache.put(customClass, converter);
        return converter;
    }

    public static NumConverter getNumConverter(Class<?> customClass) {
        NumConverter nc = converterCache.get(customClass);
        return nc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NumConverter getNumConverter(Class<?> customClass, Class<? extends NumConverter> convertClass) {
        NumConverter nc;
        if (!numConverterPropLoaded) {
            CacheExtension.loadNumConvertersFromPropertiesFile(null);
        }
        if ((nc = converterCache.get(convertClass)) == null) {
            try {
                Class<? extends NumConverter> clazz = convertClass;
                synchronized (clazz) {
                    nc = convertClass.newInstance();
                    if (convertClass.isAnnotationPresent(SingletonExtension.class)) {
                        converterCache.put(customClass, nc);
                    }
                }
            }
            catch (Exception e) {
                throw new CalculatorException(e);
            }
        }
        return nc;
    }

    public static HashMap<Class, NumConverter> getAllNumConverter() {
        return converterCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadNumConvertersFromPropertiesFile(String absolutePath) {
        File propFile;
        if (absolutePath == null) {
            numConverterPropLoaded = true;
            absolutePath = Properties.getGlobalPropertiesFile();
        }
        if ((propFile = new File(absolutePath)).exists() && propFile.isFile() && propFile.canRead()) {
            java.util.Properties prop = new java.util.Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                prop.load(fis);
                CacheExtension.loadProperties(prop);
            }
            catch (Exception e) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public static void loadProperties(java.util.Properties prop) {
        for (Map.Entry<Object, Object> kv : prop.entrySet()) {
            String[] value;
            Object oValue;
            if (!(kv.getKey() instanceof String)) continue;
            String key = (String)kv.getKey();
            if (key.startsWith("numconverter[") && (oValue = kv.getValue()) instanceof String && (value = ((String)oValue).split(">")).length == 2) {
                try {
                    Class<?> customClass = Class.forName(value[0].trim());
                    Class<?> converterClass = Class.forName(value[1].trim());
                    if (NumConverter.class.isAssignableFrom(converterClass)) {
                        CacheExtension.setNumConverter(customClass, converterClass);
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (key.startsWith("operator[") && (oValue = kv.getValue()) instanceof String) {
                try {
                    Class<?> customOperator = Class.forName(((String)oValue).trim());
                    if (Operator.class.isAssignableFrom(customOperator)) {
                        CacheExtension.setOperator(customOperator.asSubclass(Operator.class));
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (!key.startsWith("function[") || !((oValue = kv.getValue()) instanceof String)) continue;
            try {
                Class<?> customFunction = Class.forName(((String)oValue).trim());
                if (!Function.class.isAssignableFrom(customFunction)) continue;
                CacheExtension.setFunction(customFunction.asSubclass(Function.class));
            }
            catch (ClassNotFoundException e) {}
        }
    }
}

