/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc.extension;

import java.math.BigDecimal;
import org.jdice.calc.AbstractCalculator;
import org.jdice.calc.Num;
import org.jdice.calc.Operator;
import org.jdice.calc.Properties;
import org.jdice.calc.Rounding;

public class PowOperator
implements Operator {
    @Override
    public int getPriority() {
        return 15;
    }

    @Override
    public String getSymbol() {
        return "^";
    }

    @Override
    public Num calc(AbstractCalculator calc, Num value1, Num exponent) {
        int scale = Properties.getInheritedScale(calc, exponent);
        Rounding roundingMode = Properties.getInheritedRoundingMode(calc, exponent);
        return this.calc(calc, value1, exponent, scale, roundingMode);
    }

    public Num calc(AbstractCalculator calc, Num value1, Num exponent, Integer scale, Rounding roundingMode) {
        if (exponent.hasRemainder()) {
            double result = Math.pow(value1.doubleValue(), exponent.doubleValue());
            return new Num(result);
        }
        int ex = exponent.intValue();
        if (ex == 0) {
            return value1;
        }
        if (ex < 0) {
            BigDecimal one = BigDecimal.ONE;
            BigDecimal value = value1.toBigDecimal().pow(ex * -1);
            value = one.divide(value, (int)scale, roundingMode.getBigDecimalRound());
            Num result = new Num(value);
            return result;
        }
        BigDecimal value = value1.toBigDecimal().pow(exponent.toBigDecimal().intValue());
        Num result = new Num(value);
        return result;
    }

    public String toString() {
        return this.getSymbol();
    }
}

