/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.math.RoundingMode;

public enum Rounding {
    CEILING(2, RoundingMode.CEILING),
    DOWN(1, RoundingMode.DOWN),
    FLOOR(3, RoundingMode.FLOOR),
    HALF_DOWN(5, RoundingMode.DOWN),
    HALF_EVEN(6, RoundingMode.HALF_EVEN),
    HALF_UP(4, RoundingMode.HALF_UP),
    UNNECESSARY(7, RoundingMode.UNNECESSARY),
    UP(0, RoundingMode.UP);

    private int modeBigDecimal;
    private RoundingMode modeRoundingMode;

    private Rounding(int mode, RoundingMode roundingMode) {
        this.modeBigDecimal = mode;
        this.modeRoundingMode = roundingMode;
    }

    public int getBigDecimalRound() {
        return this.modeBigDecimal;
    }

    public RoundingMode getRoundingMode() {
        return this.modeRoundingMode;
    }

    public static Rounding getRoundingMode(String roundingMode) {
        for (Rounding rm : Rounding.values()) {
            if (!rm.name().equalsIgnoreCase(roundingMode)) continue;
            return rm;
        }
        return null;
    }
}

