/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jdice.calc.AbstractCalculator;
import org.jdice.calc.Function;
import org.jdice.calc.Num;
import org.jdice.calc.NumConverter;
import org.jdice.calc.Operator;
import org.jdice.calc.Rounding;
import org.jdice.calc.internal.CacheExtension;
import org.jdice.calc.internal.Objects;

public class Properties
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean DEFAULT_STRIP_TRAILING_ZEROS = true;
    public static final String DEFAULT_OUTPUT_FORMAT = "#,###,###,##0.00";
    public static final int DEFAULT_SCALE = 64;
    public static final char DEFAULT_DECIMAL_SEPARATOR = '.';
    public static final Rounding DEFAULT_ROUNDING_MODE;
    private static Rounding defRoundingMode;
    private static Integer defScale;
    private static boolean defStripTrailingZeros;
    private static char defDecimalSeparatorIN;
    private static char defDecimalSeparatorOUT;
    private static Character defGroupingSeparator;
    private static String defOutputFormat;
    private Rounding roundingMode = defRoundingMode;
    private Integer scale = defScale;
    private boolean stripTrailingZeros = defStripTrailingZeros;
    private char decimalSeparatorIN = defDecimalSeparatorIN;
    private char decimalSeparatorOUT = defDecimalSeparatorOUT;
    private Character groupingSeparator = defGroupingSeparator;
    private String outputFormat = defOutputFormat;

    public Rounding getRoundingMode() {
        return this.roundingMode;
    }

    public Properties setRoundingMode(Rounding roundingMode) {
        this.roundingMode = roundingMode;
        return this;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Properties setScale(Integer scale) {
        this.scale = scale != null && scale >= 0 ? scale : null;
        return this;
    }

    public boolean hasStripTrailingZeros() {
        return this.stripTrailingZeros;
    }

    public Properties setStripTrailingZeros(boolean stripTrailingZeros) {
        this.stripTrailingZeros = stripTrailingZeros;
        return this;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public Properties setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public char getInputDecimalSeparator() {
        return this.decimalSeparatorIN;
    }

    public char getOutputDecimalSeparator() {
        return this.decimalSeparatorOUT;
    }

    public Properties setDecimalSeparator(char inputDecimalSeparator, char outputDecimalSeparator) {
        this.decimalSeparatorIN = inputDecimalSeparator;
        this.decimalSeparatorOUT = outputDecimalSeparator;
        return this;
    }

    public Properties setInputDecimalSeparator(char inputDecimalSeparator) {
        this.decimalSeparatorIN = inputDecimalSeparator;
        return this;
    }

    public Properties setOutputDecimalSeparator(char outputDecimalSeparator) {
        this.decimalSeparatorOUT = outputDecimalSeparator;
        return this;
    }

    public Character getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(Character groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
    }

    public void load(Properties properties) {
        this.setScale(properties.getScale());
        this.setRoundingMode(properties.getRoundingMode());
        this.setStripTrailingZeros(properties.hasStripTrailingZeros());
        this.setOutputFormat(properties.getOutputFormat());
        this.setInputDecimalSeparator(properties.getInputDecimalSeparator());
        this.setOutputDecimalSeparator(properties.getOutputDecimalSeparator());
        this.setGroupingSeparator(properties.getGroupingSeparator());
    }

    public String toString() {
        return "scale: " + (this.scale != null ? this.scale : "none") + ", rounding mode: " + (Object)((Object)this.roundingMode) + ", strip trailing zeros: " + this.stripTrailingZeros + ", decimal separator: " + this.decimalSeparatorIN + (this.groupingSeparator != null ? ", grouping separator: '" + this.groupingSeparator + "'" : "") + ", outputFormat: " + (this.outputFormat != null ? this.outputFormat : "none");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Properties) {
            Properties second = (Properties)obj;
            if (!Objects.equals(this.getGroupingSeparator(), second.getGroupingSeparator())) {
                return false;
            }
            if (!Objects.equals(Character.valueOf(this.getInputDecimalSeparator()), Character.valueOf(second.getInputDecimalSeparator()))) {
                return false;
            }
            if (!Objects.equals(Character.valueOf(this.getOutputDecimalSeparator()), Character.valueOf(second.getOutputDecimalSeparator()))) {
                return false;
            }
            if (!Objects.equals(this.getOutputFormat(), second.getOutputFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.getRoundingMode(), (Object)second.getRoundingMode())) {
                return false;
            }
            if (!Objects.equals(this.getScale(), second.getScale())) {
                return false;
            }
            return Objects.equals(this.hasStripTrailingZeros(), second.hasStripTrailingZeros());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.groupingSeparator, Character.valueOf(this.decimalSeparatorIN), Character.valueOf(this.decimalSeparatorOUT), this.outputFormat, this.roundingMode, this.scale, this.stripTrailingZeros});
    }

    public void saveGlobalProperties() throws IOException {
        File propFile = new File(Properties.getGlobalPropertiesFile());
        if (propFile.createNewFile() || propFile.isFile()) {
            java.util.Properties prop = new java.util.Properties();
            if (this.getRoundingMode() != null) {
                prop.put("roundingMode", this.getRoundingMode().name());
            }
            if (this.getScale() != null) {
                prop.put("scale", this.getScale());
            }
            prop.put("stripTrailingZeros", Boolean.toString(this.hasStripTrailingZeros()));
            prop.put("decimalSeparator.in", "'" + this.getInputDecimalSeparator() + "'");
            prop.put("decimalSeparator.out", "'" + this.getOutputDecimalSeparator() + "'");
            if (this.getGroupingSeparator() != null) {
                prop.put("groupingSeparator", this.getGroupingSeparator());
            }
            if (this.getOutputFormat() != null) {
                prop.put("outputFormat", this.getOutputFormat());
            }
            HashMap<Class, NumConverter> cncs = CacheExtension.getAllNumConverter();
            int count = 0;
            for (Map.Entry<Class, NumConverter> cnc : cncs.entrySet()) {
                prop.put("numconverter[" + count++ + "]", cnc.getKey().getName() + " > " + cnc.getValue().getClass().getName());
            }
            HashMap<Class<? extends Operator>, Operator> cops = CacheExtension.getOperators();
            count = 0;
            for (Map.Entry<Class<? extends Operator>, Operator> cop : cops.entrySet()) {
                prop.put("operator[" + count++ + "]", cop.getKey().getName());
            }
            HashMap<Class<? extends Function>, Function> cfns = CacheExtension.getFunctions();
            count = 0;
            for (Map.Entry<Class<? extends Function>, Function> cfn : cfns.entrySet()) {
                prop.put("function[" + count++ + "]", cfn.getKey().getName());
            }
            FileOutputStream fos = new FileOutputStream(propFile);
            prop.store(fos, "Global properties for jCalc");
            fos.close();
            fos.flush();
        }
    }

    public static Rounding getInheritedRoundingMode(AbstractCalculator calc, Num value) {
        if (value.getRoundingMode() == null) {
            if (calc != null && calc.getRoundingMode() != null) {
                return calc.getRoundingMode();
            }
            return defRoundingMode;
        }
        return value.getRoundingMode();
    }

    public static Properties getInheritedProperties(AbstractCalculator calc, Num value) {
        Properties prop = new Properties();
        return prop;
    }

    public static int getInheritedScale(AbstractCalculator calc, Num value) {
        if (value.getScale() == null) {
            if (calc != null && calc.getScale() != null) {
                return calc.getScale();
            }
            return 64;
        }
        return value.getScale();
    }

    public static String getGlobalPropertiesFile() {
        String CONF_PROPERTIES = "jcalc.properties";
        String path = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL res = classLoader.getResource(".");
            String abspath = res.getFile();
            path = abspath.endsWith(File.separator) ? abspath + "jcalc.properties" : abspath + File.separatorChar + "jcalc.properties";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File propFile;
        defRoundingMode = DEFAULT_ROUNDING_MODE = Rounding.HALF_UP;
        defStripTrailingZeros = true;
        defDecimalSeparatorIN = (char)46;
        defDecimalSeparatorOUT = (char)46;
        String propPath = Properties.getGlobalPropertiesFile();
        if (propPath != null && (propFile = new File(propPath)) != null && propFile.exists() && propFile.isFile() && propFile.canRead()) {
            java.util.Properties prop = new java.util.Properties();
            FileInputStream fis = null;
            try {
                String propOF;
                String propGS;
                String propDSout;
                String propDSin;
                String propDS;
                Boolean stz;
                String propSTZ;
                String propS;
                Rounding rm;
                fis = new FileInputStream(propFile);
                prop.load(fis);
                String propRM = prop.getProperty("roundingMode");
                if (propRM != null && propRM.trim().length() != 0 && (rm = Rounding.getRoundingMode(propRM.trim())) != null) {
                    defRoundingMode = rm;
                }
                if ((propS = prop.getProperty("scale")) != null && propS.trim().length() != 0) {
                    try {
                        Integer sc = Integer.parseInt(propS);
                        if (sc != null) {
                            defScale = sc;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((propSTZ = prop.getProperty("stripTrailingZeros")) != null && propSTZ.trim().length() != 0 && (stz = Boolean.valueOf(Boolean.parseBoolean(propSTZ.trim()))) != null) {
                    defStripTrailingZeros = stz;
                }
                if ((propDS = prop.getProperty("decimalSeparator")) != null && propDS.trim().matches("['\"](.){1}['\"]")) {
                    defDecimalSeparatorIN = propDS.trim().charAt(1);
                }
                if ((propDSin = prop.getProperty("decimalSeparator.in")) != null && propDSin.trim().matches("['\"](.){1}['\"]")) {
                    defDecimalSeparatorIN = propDSin.trim().charAt(1);
                }
                if ((propDSout = prop.getProperty("decimalSeparator.out")) != null && propDSout.trim().matches("['\"](.){1}['\"]")) {
                    defDecimalSeparatorOUT = propDSout.trim().charAt(1);
                }
                if ((propGS = prop.getProperty("groupingSeparator")) != null && propGS.trim().matches("['\"](.){1}['\"]")) {
                    defGroupingSeparator = Character.valueOf(propGS.trim().charAt(1));
                }
                if ((propOF = prop.getProperty("outputFormat")) != null && propOF.trim().length() != 0) {
                    defOutputFormat = propOF.trim();
                }
                CacheExtension.loadProperties(prop);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

