/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdice.calc.AbstractCalculator;
import org.jdice.calc.CalculatorException;
import org.jdice.calc.NumConverter;
import org.jdice.calc.Properties;
import org.jdice.calc.Rounding;
import org.jdice.calc.SingletonExtension;
import org.jdice.calc.internal.CacheExtension;

public class Num
implements Cloneable,
Comparable<Num>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Properties properties;
    private Object originalValue;
    private BigDecimal in = BigDecimal.ZERO;
    private BigDecimal out = BigDecimal.ZERO;

    public Num() {
    }

    public Num(Object value) {
        this.setValue(value, null, null);
    }

    public Num(String name, Object value) {
        this(value);
        this.name = name;
    }

    public Num(Object value, Class<? extends NumConverter> converter) {
        this.setValue(value, null, converter);
    }

    public Num(String name, Object value, Class<? extends NumConverter> converter) {
        this.name = name;
        this.setValue(value, null, converter);
    }

    public Num(String value, char decimalSeparator) {
        this.setValue(value, Character.valueOf(decimalSeparator), null);
    }

    public Num(String name, String value, char decimalSeparator) {
        this(value, decimalSeparator);
        this.name = name;
    }

    public Num set(Object value) {
        return this.setValue(value, null, null);
    }

    public Num set(Object value, Class<? extends NumConverter> converter) {
        return this.setValue(value, null, converter);
    }

    public Num set(String value, char decimalSeparator) {
        return this.setValue(value, Character.valueOf(decimalSeparator), null);
    }

    private Num setValue(Object value, Character decimalSeparator, Class<? extends NumConverter> converterClass) {
        block26: {
            try {
                this.originalValue = value;
                if (value instanceof Short) {
                    this.in = new BigDecimal(((Short)this.originalValue).shortValue());
                    break block26;
                }
                if (value instanceof Integer) {
                    this.in = new BigDecimal((Integer)this.originalValue);
                    break block26;
                }
                if (value instanceof Long) {
                    this.in = new BigDecimal((Long)this.originalValue);
                    break block26;
                }
                if (value instanceof Float) {
                    this.in = new BigDecimal(((Float)this.originalValue).toString());
                    break block26;
                }
                if (value instanceof Double) {
                    this.in = new BigDecimal(((Double)this.originalValue).toString());
                    break block26;
                }
                if (value instanceof BigInteger) {
                    this.in = new BigDecimal((BigInteger)this.originalValue);
                    break block26;
                }
                if (value instanceof BigDecimal) {
                    this.in = (BigDecimal)this.originalValue;
                    break block26;
                }
                if (value instanceof String) {
                    if (decimalSeparator == null) {
                        decimalSeparator = Character.valueOf(this.getProperties().getInputDecimalSeparator());
                    } else {
                        this.getProperties().setInputDecimalSeparator(decimalSeparator.charValue());
                    }
                    String strValue = (String)value;
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                    dfs.setDecimalSeparator('.');
                    DecimalFormat df = new DecimalFormat("#0.0#", dfs);
                    df.setParseBigDecimal(true);
                    String csr = decimalSeparator.charValue() == '.' ? "([^-+\\d\\" + decimalSeparator + "]+)" : "([^-+\\d" + decimalSeparator + "]+)";
                    Pattern p = Pattern.compile(csr);
                    Matcher m = p.matcher(strValue);
                    boolean isComplexStr = m.find();
                    if (isComplexStr) {
                        strValue = Num.parseComplexString(strValue, decimalSeparator);
                        if (decimalSeparator.charValue() != '.') {
                            strValue = strValue.replace(decimalSeparator.charValue(), '.');
                        }
                        this.in = (BigDecimal)df.parse(strValue);
                    } else {
                        try {
                            this.in = (BigDecimal)df.parse(strValue);
                        }
                        catch (ParseException pe) {
                            strValue = Num.parseComplexString(strValue, decimalSeparator);
                            this.in = (BigDecimal)df.parse(strValue);
                        }
                    }
                    String tmp = this.in.toString();
                    int scale = tmp.indexOf(46);
                    if (scale != -1) {
                        this.setScale(tmp.length() - scale - 1);
                        if (strValue.endsWith("0")) {
                            this.setStripTrailingZeros(false);
                        }
                    }
                    break block26;
                }
                if (value instanceof AbstractCalculator) {
                    AbstractCalculator ac = (AbstractCalculator)value;
                    this.originalValue = ac;
                    Num n = ac.calculate();
                    this.in = n.toBigDecimal();
                    break block26;
                }
                if (value instanceof Num) {
                    Num tmp = (Num)value;
                    this.setProperties(tmp.getProperties());
                    this.in = tmp.toBigDecimal();
                    break block26;
                }
                if (value == null) {
                    this.originalValue = 0;
                    this.in = new BigDecimal((Integer)this.originalValue);
                    break block26;
                }
                NumConverter nc = null;
                if (converterClass != null && (nc = converterClass.newInstance()) != null && converterClass.isAnnotationPresent(SingletonExtension.class)) {
                    CacheExtension.setNumConverter(value.getClass(), nc);
                }
                if (nc == null) {
                    nc = CacheExtension.getNumConverter(value.getClass());
                }
                if (nc != null) {
                    this.in = nc.toNum(value);
                    break block26;
                }
                throw new CalculatorException("Unsupported type '" + value.getClass() + "'! Supported types are: short, int, long, float, double, Short, Integer, Long, Float, Double, BigInteger, BigDecimal, String");
            }
            catch (ParseException pe) {
                throw new CalculatorException("Parse exception with '" + value + "'", pe);
            }
            catch (Exception e) {
                throw new CalculatorException(e);
            }
        }
        this.out = this.in;
        return this;
    }

    public Num setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public Num setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Num setScale(int scale) {
        this.getProperties().setScale(scale);
        return this;
    }

    public Num setScale(int scale, Rounding roundingMode) {
        this.setScale(scale);
        this.setRoundingMode(roundingMode);
        return this;
    }

    public Integer getScale() {
        return this.getProperties().getScale();
    }

    public Num setRoundingMode(Rounding roundingMode) {
        this.getProperties().setRoundingMode(roundingMode);
        return this;
    }

    public Rounding getRoundingMode() {
        return this.getProperties().getRoundingMode();
    }

    public Num setStripTrailingZeros(boolean stripTrailingZeros) {
        this.getProperties().setStripTrailingZeros(stripTrailingZeros);
        return this;
    }

    public boolean hasStripTrailingZeros() {
        return this.getProperties().hasStripTrailingZeros();
    }

    public Num setOutputFormat(String format) {
        this.getProperties().setOutputFormat(format);
        return this;
    }

    public String getOutputFormat() {
        return this.getProperties().getOutputFormat();
    }

    public BigDecimal toBigDecimal() {
        return this.toBigDecimal(this.getProperties().getScale(), this.getProperties().getRoundingMode(), this.getProperties().hasStripTrailingZeros());
    }

    public BigDecimal toBigDecimal(int scale) {
        return this.toBigDecimal(scale, this.getProperties().getRoundingMode(), this.getProperties().hasStripTrailingZeros());
    }

    public BigDecimal toBigDecimal(int scale, Rounding roundingMode) {
        return this.toBigDecimal(scale, roundingMode, this.getProperties().hasStripTrailingZeros());
    }

    public BigDecimal toBigDecimal(Integer scale, Rounding rounding, boolean stripTrailingZeros) {
        this.out = this.in;
        if (scale != null && rounding != null) {
            this.out = this.out.setScale((int)scale, rounding.getBigDecimalRound());
        } else if (scale != null && rounding == null) {
            this.out = this.out.setScale(scale);
        }
        if (stripTrailingZeros) {
            this.out = this.out.stripTrailingZeros();
        }
        return this.out;
    }

    public BigDecimal remainder() {
        BigDecimal out = this.toBigDecimal();
        BigDecimal fraction = out.remainder(BigDecimal.ONE);
        return fraction;
    }

    public int remainderSize() {
        BigDecimal fraction = this.remainder();
        String tmp = fraction.toString();
        int n = tmp.indexOf(46);
        if (n != -1) {
            return tmp.length() - n - 1;
        }
        return 0;
    }

    public boolean hasRemainder() {
        String out = this.toString();
        return out.contains(".");
    }

    public boolean isZero() {
        BigDecimal out = this.toBigDecimal();
        return out.doubleValue() == 0.0;
    }

    public boolean isNegative() {
        BigDecimal out = this.toBigDecimal();
        return out.doubleValue() < 0.0;
    }

    public <T> T toObject(Class<T> toClass) {
        return (T)this.toObject(toClass, null, null);
    }

    public <T> T toObject(Class<T> toClass, Class<? extends NumConverter> converterClass) {
        return (T)this.toObject(toClass, null, converterClass);
    }

    public <T> T toObject(Class<T> toClass, NumConverter numConverter) {
        return (T)this.toObject(toClass, numConverter, null);
    }

    private Object toObject(Class toClass, NumConverter converter, Class<? extends NumConverter> converterClass) {
        try {
            NumConverter nc = null;
            if (converter != null) {
                nc = converter;
                if (converterClass.isAnnotationPresent(SingletonExtension.class)) {
                    CacheExtension.setNumConverter(toClass, nc);
                }
            } else if (converterClass != null && (nc = converterClass.newInstance()) != null && converterClass.isAnnotationPresent(SingletonExtension.class)) {
                CacheExtension.setNumConverter(toClass, nc);
            }
            if (nc == null) {
                nc = CacheExtension.getNumConverter(toClass);
            }
            if (nc != null) {
                return nc.fromNum(this);
            }
            throw new CalculatorException("Unsupported type '" + toClass + "'! Supported types are: short, int, long, float, double, Short, Integer, Long, Float, Double, BigInteger, BigDecimal, String");
        }
        catch (Exception e) {
            throw new CalculatorException("Unsupported type '" + toClass + "'! Supported types are: short, int, long, float, double, Short, Integer, Long, Float, Double, BigInteger, BigDecimal, String", e);
        }
    }

    public String toString() {
        return this.toString(this.getProperties().getGroupingSeparator(), this.getProperties().getOutputDecimalSeparator(), this.getProperties().getOutputFormat());
    }

    public String toString(String format) {
        return this.toString(this.getProperties().getGroupingSeparator(), this.getProperties().getOutputDecimalSeparator(), format);
    }

    public String toString(char decimalSeparator) {
        return this.toString(null, decimalSeparator, null);
    }

    public String toString(Character groupingSeparator, char decimalSeparator) {
        return this.toString(groupingSeparator, decimalSeparator, this.getProperties().getOutputFormat());
    }

    public String toString(Character groupingSeparator, char decimalSeparator, String format) {
        Integer scale;
        BigDecimal out = this.toBigDecimal();
        DecimalFormatSymbols custom = new DecimalFormatSymbols();
        custom.setDecimalSeparator(decimalSeparator);
        if (groupingSeparator != null) {
            custom.setGroupingSeparator(groupingSeparator.charValue());
        }
        DecimalFormat decFormat = null;
        decFormat = format != null ? new DecimalFormat(format) : new DecimalFormat();
        decFormat.setDecimalFormatSymbols(custom);
        if (groupingSeparator == null) {
            decFormat.setGroupingUsed(false);
        }
        if ((scale = this.getScale()) != null && !this.hasStripTrailingZeros()) {
            decFormat.setMinimumFractionDigits(scale);
        }
        if (scale == null) {
            scale = 64;
            if (!this.hasStripTrailingZeros()) {
                int p = this.remainderSize();
                decFormat.setMinimumFractionDigits(p);
            }
        }
        decFormat.setMaximumFractionDigits(scale);
        return decFormat.format(out);
    }

    public Object getOriginalValue() {
        return this.originalValue;
    }

    public Num clone() {
        Num copy = new Num();
        copy.name = this.name;
        copy.getProperties().load(this.getProperties());
        copy.originalValue = this.originalValue;
        copy.in = new BigDecimal(this.in.toString());
        copy.out = new BigDecimal(this.out.toString());
        return copy;
    }

    public int hashCode() {
        return this.toBigDecimal().hashCode();
    }

    public boolean isEqual(Object value) {
        if (value == null) {
            return false;
        }
        if (this == value) {
            return true;
        }
        Num tmp = null;
        tmp = value instanceof Num ? (Num)value : new Num(value);
        int i = tmp.toBigDecimal().compareTo(this.toBigDecimal());
        return i == 0;
    }

    public boolean isEqual(String value, char decimalSeparator) {
        return this.isEqual(new Num(value, decimalSeparator));
    }

    public boolean isEqual(Object value, int scale) {
        return this.isEqual(value, scale, null);
    }

    public boolean isEqual(Object value, boolean autoscale) {
        Num numA = this;
        Num numB = null;
        numB = value instanceof Num ? (Num)value : new Num(value);
        int minScale = numA.remainderSize();
        int bScale = numB.remainderSize();
        if (bScale < minScale) {
            minScale = bScale;
        }
        return this.isEqual(value, minScale);
    }

    public boolean isEqual(Object value, int scale, Rounding rounding) {
        Num numA = this;
        Num numB = null;
        numB = value instanceof Num ? (Num)value : new Num(value);
        BigDecimal a = numA.toBigDecimal();
        BigDecimal b = numB.toBigDecimal();
        if (rounding != null) {
            a = a.setScale(scale, rounding.getBigDecimalRound());
            b = b.setScale(scale, rounding.getBigDecimalRound());
        } else {
            a = a.setScale(scale, this.getProperties().getRoundingMode().getBigDecimalRound());
            b = b.setScale(scale, this.getProperties().getRoundingMode().getBigDecimalRound());
        }
        return a.equals(b);
    }

    public boolean isEqual(Object value, Class<? extends NumConverter> converter) {
        if (!(value instanceof Num)) {
            Num tmp = new Num(value, converter);
            return this.isEqual(tmp);
        }
        return this.isEqual((Num)value);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Num) {
            return this.toBigDecimal().equals(((Num)object).toBigDecimal());
        }
        return false;
    }

    public boolean equals(BigDecimal obj) {
        if (obj == null) {
            return false;
        }
        if (this.toBigDecimal() == obj) {
            return true;
        }
        return this.toBigDecimal().equals(obj);
    }

    @Override
    public int compareTo(Num value) {
        return this.toBigDecimal().compareTo(value.toBigDecimal());
    }

    public byte byteValue() {
        return this.toBigDecimal().byteValue();
    }

    public byte byteValueExact() {
        return this.toBigDecimal().byteValueExact();
    }

    public double doubleValue() {
        return this.toBigDecimal().doubleValue();
    }

    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    public int intValue() {
        return this.toBigDecimal().intValue();
    }

    public int intValueExact() {
        return this.toBigDecimal().intValueExact();
    }

    public long longValue() {
        return this.toBigDecimal().longValue();
    }

    public long longValueExact() {
        return this.toBigDecimal().longValueExact();
    }

    public short shortValue() {
        return this.toBigDecimal().shortValue();
    }

    public short shortValueExact() {
        return this.toBigDecimal().shortValueExact();
    }

    public int signum() {
        return this.toBigDecimal().signum();
    }

    public String toEngineeringString() {
        return this.toBigDecimal().toEngineeringString();
    }

    public Num abs() {
        Num abs = new Num(this.toBigDecimal().abs());
        return abs;
    }

    public Num ceil() {
        Num ceil = new Num();
        BigDecimal c = this.toBigDecimal();
        ceil.setValue(c.setScale(0, 2), null, null);
        return ceil;
    }

    public Num floor() {
        Num floor = new Num();
        BigDecimal c = this.toBigDecimal();
        floor.setValue(c.setScale(0, 3), null, null);
        return floor;
    }

    public static Num toNum(Object object) {
        if (object instanceof Num) {
            return ((Num)object).clone();
        }
        Num n = new Num(object);
        return n;
    }

    private static String cleanNumber(String value, char decimalSeparator) {
        String regex = "[^0-9-" + decimalSeparator + "]";
        if (decimalSeparator == '.') {
            regex = regex.replace(".", "\\.");
        }
        String strip = value.replaceAll(regex, "");
        strip = strip.replace(decimalSeparator + "", ".");
        return strip;
    }

    public static String NUM_REGEX(char ds) {
        String r = "([-+\\d]\\s?[\\d ,'" + ds + "]+)+";
        if (ds == '.') {
            r = r.replace(".", "\\.");
        }
        return r;
    }

    public static String parseComplexString(String value, Character decimalSeparator) throws ParseException {
        String strValue = value;
        Pattern pat = Pattern.compile(Num.NUM_REGEX('.'));
        Matcher m = pat.matcher(strValue);
        int find = 0;
        while (m.find()) {
            if (++find > 1) {
                throw new ParseException("Detect more than one number in String: " + value, 0);
            }
            if (m.groupCount() == 1) {
                strValue = m.group(1);
                continue;
            }
            throw new ParseException("Detect more than one number in String: " + value, 0);
        }
        if (find == 0) {
            throw new ParseException("Can't parse " + strValue, 0);
        }
        strValue = Num.cleanNumber(strValue, decimalSeparator.charValue());
        if (decimalSeparator != null && decimalSeparator.charValue() != '.') {
            strValue = strValue.replace(decimalSeparator + "", ".");
        }
        return strValue;
    }
}

