/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.text.ParseException;
import org.jdice.calc.AbstractCalculator;
import org.jdice.calc.Num;
import org.jdice.calc.extension.Abs;
import org.jdice.calc.extension.AbsFunction;
import org.jdice.calc.extension.Add;
import org.jdice.calc.extension.AddOperator;
import org.jdice.calc.extension.Div;
import org.jdice.calc.extension.DivOperator;
import org.jdice.calc.extension.Log;
import org.jdice.calc.extension.LogFunction;
import org.jdice.calc.extension.Mod;
import org.jdice.calc.extension.ModOperator;
import org.jdice.calc.extension.Mul;
import org.jdice.calc.extension.MulOperator;
import org.jdice.calc.extension.Pow;
import org.jdice.calc.extension.PowOperator;
import org.jdice.calc.extension.Sqrt;
import org.jdice.calc.extension.SqrtFunction;
import org.jdice.calc.extension.Sub;
import org.jdice.calc.extension.SubOperator;

public final class Calculator
extends AbstractCalculator<Calculator>
implements Add<Calculator>,
Sub<Calculator>,
Div<Calculator>,
Mul<Calculator>,
Mod<Calculator>,
Pow<Calculator>,
Abs<Calculator>,
Sqrt<Calculator>,
Log<Calculator> {
    @Override
    protected Calculator getThis() {
        return this;
    }

    public static Calculator builder() {
        Calculator calc = new Calculator();
        return calc;
    }

    public static Calculator builder(String expression) throws ParseException {
        Calculator calc = new Calculator();
        calc.expression(expression);
        return calc;
    }

    public static Calculator builder(String expression, Object ... values) throws ParseException {
        Calculator calc = new Calculator();
        calc.expression(expression, values);
        return calc;
    }

    @Override
    public Calculator add() {
        return (Calculator)this.operator(AddOperator.class);
    }

    @Override
    public Calculator add(Object value) {
        return (Calculator)this.operator(AddOperator.class, value);
    }

    @Override
    public Calculator add(String value, char decimalSeparator) {
        return (Calculator)this.operator(AddOperator.class, value, decimalSeparator);
    }

    @Override
    public Calculator sub() {
        return (Calculator)this.operator(SubOperator.class);
    }

    @Override
    public Calculator sub(Object value) {
        return (Calculator)this.operator(SubOperator.class, value);
    }

    @Override
    public Calculator sub(String value, char decimalSeparator) {
        return (Calculator)this.operator(SubOperator.class, value, decimalSeparator);
    }

    @Override
    public Calculator div() {
        return (Calculator)this.operator(DivOperator.class);
    }

    @Override
    public Calculator div(Object value) {
        return (Calculator)this.operator(DivOperator.class, value);
    }

    @Override
    public Calculator div(String value, char decimalSeparator) {
        return (Calculator)this.operator(DivOperator.class, value, decimalSeparator);
    }

    @Override
    public Calculator mul() {
        return (Calculator)this.operator(MulOperator.class);
    }

    @Override
    public Calculator mul(Object value) {
        return (Calculator)this.operator(MulOperator.class, value);
    }

    @Override
    public Calculator mul(String value, char decimalSeparator) {
        return (Calculator)this.operator(MulOperator.class, value, decimalSeparator);
    }

    @Override
    public Calculator pow() {
        return (Calculator)this.operator(PowOperator.class);
    }

    @Override
    public Calculator pow(Object value) {
        return (Calculator)this.operator(PowOperator.class, value);
    }

    @Override
    public Calculator pow(String value, char decimalSeparator) {
        return (Calculator)this.operator(PowOperator.class, value, decimalSeparator);
    }

    @Override
    public Calculator abs(AbstractCalculator expression) {
        return (Calculator)this.function(AbsFunction.class, expression);
    }

    @Override
    public Calculator abs(Object value) {
        return (Calculator)this.function(AbsFunction.class, new Num(value));
    }

    @Override
    public Calculator abs(String value, char decimalSeparator) {
        return (Calculator)this.function(AbsFunction.class, new Num(value, decimalSeparator));
    }

    @Override
    public Calculator sqrt(AbstractCalculator expression) {
        return (Calculator)this.function(SqrtFunction.class, expression);
    }

    @Override
    public Calculator sqrt(Object value) {
        return (Calculator)this.function(SqrtFunction.class, new Num(value));
    }

    @Override
    public Calculator sqrt(String value, char decimalSeparator) {
        return (Calculator)this.function(SqrtFunction.class, new Num(value, decimalSeparator));
    }

    @Override
    public Calculator mod() {
        return (Calculator)this.operator(ModOperator.class);
    }

    @Override
    public Calculator mod(Object value) {
        return (Calculator)this.operator(ModOperator.class, value);
    }

    @Override
    public Calculator mod(String value, char decimalSeparator) {
        return (Calculator)this.operator(ModOperator.class, value, decimalSeparator);
    }

    @Override
    public Calculator log(AbstractCalculator expression) {
        return (Calculator)this.function(LogFunction.class, expression);
    }

    @Override
    public Calculator log(Object value) {
        return (Calculator)this.function(LogFunction.class, value);
    }

    @Override
    public Calculator log(String value, char decimalSeparator) {
        return (Calculator)this.function(LogFunction.class, value, Character.valueOf(decimalSeparator));
    }
}

