/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import org.jdice.calc.BindExtension;
import org.jdice.calc.CalculatorException;
import org.jdice.calc.Extension;
import org.jdice.calc.Function;
import org.jdice.calc.Num;
import org.jdice.calc.NumConverter;
import org.jdice.calc.Operator;
import org.jdice.calc.Properties;
import org.jdice.calc.Rounding;
import org.jdice.calc.Step;
import org.jdice.calc.internal.BindExtensionProvider;
import org.jdice.calc.internal.Bracket;
import org.jdice.calc.internal.CList;
import org.jdice.calc.internal.CListListener;
import org.jdice.calc.internal.CacheExtension;
import org.jdice.calc.internal.FunctionData;
import org.jdice.calc.internal.InfixParser;
import org.jdice.calc.internal.PostfixCalculator;
import org.jdice.calc.internal.UseExtension;

public abstract class AbstractCalculator<CALC> {
    private CList infix = new CList(new CListListener(){

        @Override
        public void change() {
            AbstractCalculator.this.isInfixChanged = true;
        }
    });
    private boolean isInfixChanged = true;
    private InfixParser infixParser;
    private final PostfixCalculator postfixCalculator = new PostfixCalculator();
    private CList postfix = new CList();
    private Num lastCalculatedValue;
    private LinkedList<Step> calculatingSteps;
    private Properties properties;
    private UseExtension useExtensions;
    private static boolean isImplExtRegistered = false;
    private AbstractCalculator<CALC> parentCalculator;
    private AbstractCalculator<CALC> childCalculator;
    private boolean isBind = false;
    private boolean isUnbind = false;
    private boolean trackSteps = false;

    private void detectImplmentedExtension() {
        if (!isImplExtRegistered) {
            Class<?>[] declared;
            CALC o = this.getThis();
            Class<?> thisClass = o.getClass();
            for (Class<?> declare : declared = thisClass.getSuperclass().getInterfaces()) {
                this.detectImplmentedExtension(declare);
            }
            for (Class<?> declare : declared = thisClass.getInterfaces()) {
                this.detectImplmentedExtension(declare);
            }
            isImplExtRegistered = true;
        }
    }

    private void detectImplmentedExtension(Class declare) {
        Class<? extends Extension> c = BindExtensionProvider.getExtension(declare);
        if (c == null && declare.isAnnotationPresent(BindExtension.class)) {
            BindExtension impl = declare.getAnnotation(BindExtension.class);
            if (impl != null) {
                c = impl.implementation();
            }
            BindExtensionProvider.bind(declare, c);
        }
        if (c != null) {
            if (Operator.class.isAssignableFrom(c)) {
                CacheExtension.setOperator(c);
            }
            if (Function.class.isAssignableFrom(c)) {
                CacheExtension.setFunction(c);
            }
        }
    }

    protected abstract CALC getThis();

    public CALC use(Class<? extends Extension> operationClass) {
        if (this.useExtensions == null) {
            this.useExtensions = new UseExtension();
        }
        if (Operator.class.isAssignableFrom(operationClass)) {
            this.useExtensions.registerOperator(operationClass.asSubclass(Operator.class));
        }
        if (Function.class.isAssignableFrom(operationClass)) {
            this.useExtensions.registerFunction(operationClass.asSubclass(Function.class));
        }
        return this.getThis();
    }

    public UseExtension getUsedExtensions() {
        return this.useExtensions;
    }

    public CALC val(Object value) {
        Num val = null;
        val = value instanceof Num ? (Num)value : new Num(value);
        this.infix.add(val);
        return this.getThis();
    }

    public CALC val(Object value, Class<? extends NumConverter> converter) {
        this.infix.add(new Num(value, converter));
        return this.getThis();
    }

    public CALC val(String value, char decimalSeparator) {
        this.infix.add(new Num(value, decimalSeparator));
        return this.getThis();
    }

    public final CALC operator(Class<? extends Operator> operator) {
        this.infix.add(operator);
        return this.getThis();
    }

    protected final CALC operator(Class<? extends Operator> operator, Object value) {
        Num tmp = null;
        tmp = value instanceof Num ? (Num)value : new Num(value);
        this.infix.add(CacheExtension.getOperator(operator));
        this.infix.add(tmp);
        return this.getThis();
    }

    protected final CALC operator(Class<? extends Operator> operator, String value, char decimalSeparator) {
        return this.operator(operator, new Num(value, decimalSeparator));
    }

    public final CALC function(Class<? extends Function> function, Object ... values) {
        Function fn = CacheExtension.getFunction(function);
        FunctionData fd = new FunctionData(fn, values);
        this.infix.addFunction(fd);
        return this.getThis();
    }

    public final CALC expression(String expression) throws ParseException {
        this.detectImplmentedExtension();
        if (this.infixParser == null) {
            this.infixParser = new InfixParser();
        }
        CList infix = this.infixParser.parse(this.useExtensions, this.getProperties(), expression, new Object[0]);
        this.expression(infix, false);
        return this.getThis();
    }

    public final CALC expression(String expression, Object ... values) throws ParseException {
        this.detectImplmentedExtension();
        if (this.infixParser == null) {
            this.infixParser = new InfixParser();
        }
        CList infix = this.infixParser.parse(this.useExtensions, this.getProperties(), expression, values);
        this.expression(infix, false);
        return this.getThis();
    }

    public CALC expression(AbstractCalculator expression, boolean withinBrackets) {
        this.expression(expression.infix, withinBrackets);
        return this.getThis();
    }

    private final CALC expression(CList infix, boolean withinBrackets) {
        if (withinBrackets) {
            this.infix.add(Bracket.OPEN);
        }
        Iterator<Object> it = infix.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof Num) {
                this.infix.add((Num)o);
                continue;
            }
            if (o instanceof Operator) {
                this.infix.add((Operator)o);
                continue;
            }
            if (o instanceof FunctionData) {
                this.infix.add((FunctionData)o);
                continue;
            }
            if (o instanceof Function) {
                this.infix.add((Function)o);
                continue;
            }
            if (!(o instanceof Bracket)) continue;
            this.infix.add((Bracket)((Object)o));
        }
        if (withinBrackets) {
            this.infix.add(Bracket.CLOSE);
        }
        return this.getThis();
    }

    public CALC openBracket() {
        this.infix.add(Bracket.OPEN);
        return this.getThis();
    }

    public CALC closeBracket() {
        this.infix.add(Bracket.CLOSE);
        return this.getThis();
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public CALC setProperties(Properties properties) {
        this.properties = properties;
        return this.getThis();
    }

    public CALC setScale(Integer scale) {
        this.getProperties().setScale(scale);
        return this.getThis();
    }

    public Integer getScale() {
        return this.getProperties().getScale();
    }

    public CALC setRoundingMode(Rounding roundingMode) {
        this.getProperties().setRoundingMode(roundingMode);
        return this.getThis();
    }

    public Rounding getRoundingMode() {
        return this.getProperties().getRoundingMode();
    }

    public CALC setDecimalSeparator(char decimalSeparator) {
        this.getProperties().setInputDecimalSeparator(decimalSeparator);
        this.getProperties().setOutputDecimalSeparator(decimalSeparator);
        return this.getThis();
    }

    public char getDecimalSeparator() {
        return this.getProperties().getInputDecimalSeparator();
    }

    public CALC setGroupingSeparator(char decimalSeparator) {
        this.getProperties().setGroupingSeparator(Character.valueOf(decimalSeparator));
        return this.getThis();
    }

    public char getGroupingSeparator() {
        return this.getProperties().getGroupingSeparator().charValue();
    }

    public boolean hasStripTrailingZeros() {
        return this.getProperties().hasStripTrailingZeros();
    }

    public CALC setStripTrailingZeros(boolean stripTrailingZeros) {
        this.getProperties().setStripTrailingZeros(stripTrailingZeros);
        return this.getThis();
    }

    public CALC setTracingSteps(boolean trackSteps) {
        this.trackSteps = trackSteps;
        return this.getThis();
    }

    public boolean isTracingSteps() {
        return this.trackSteps;
    }

    public LinkedList<Step> getTracedSteps() {
        return this.calculatingSteps;
    }

    public Num calculate() {
        this.unbind();
        this.prepareForNewCalculation();
        PostfixCalculator pc = this.convertToPostfix();
        Num cv = pc.calculate(this, this.postfix, this.trackSteps);
        this.lastCalculatedValue = cv.clone();
        return cv;
    }

    public <T extends AbstractCalculator> T bind(Class<T> clazz) {
        AbstractCalculator<CALC> bParent;
        AbstractCalculator childCalc = null;
        try {
            childCalc = (AbstractCalculator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new CalculatorException(e);
        }
        if (childCalc instanceof AbstractCalculator) {
            bParent = this;
            while (bParent != null && bParent.childCalculator != null) {
                bParent = bParent.childCalculator;
            }
        } else {
            throw new CalculatorException("Use calculator which is type of AbstractCalculator", new IllegalArgumentException());
        }
        childCalc.parentCalculator = bParent;
        childCalc.isBind = true;
        bParent.childCalculator = childCalc;
        return (T)childCalc;
    }

    private CALC unbind() {
        if (this.childCalculator != null) {
            this.unbindAll(this);
        }
        return (CALC)this;
    }

    private CALC unbindAll(AbstractCalculator<CALC> undbindFrom) {
        AbstractCalculator<CALC> tmpParent;
        AbstractCalculator<CALC> root = undbindFrom.parentCalculator != null ? undbindFrom.parentCalculator : undbindFrom;
        AbstractCalculator<CALC> child = root.childCalculator;
        while (root != null && (tmpParent = root.parentCalculator) != null) {
            root = tmpParent;
            child = root.childCalculator;
        }
        while (child != null) {
            if (!child.isUnbind) {
                root.expression(child, false);
            }
            child.isUnbind = true;
            child = child.childCalculator;
        }
        return (CALC)undbindFrom;
    }

    public String getPostfix() {
        this.unbind();
        this.convertToPostfix();
        return InfixParser.toString(this.postfix);
    }

    private PostfixCalculator convertToPostfix() {
        if (this.postfix == null || this.postfix.size() == 0 || this.isInfixChanged) {
            this.postfixCalculator.toPostfix(this.infix);
            this.postfix = this.postfixCalculator.getPostfix();
            this.isInfixChanged = false;
        }
        return this.postfixCalculator;
    }

    public String getInfix() {
        this.unbind();
        return this.toString();
    }

    public final CALC setInfix(CList infix) {
        this.infix = infix;
        return this.getThis();
    }

    public boolean isCalculated() {
        return this.lastCalculatedValue != null;
    }

    public Num getCalculatedValue() {
        if (this.lastCalculatedValue != null) {
            return this.lastCalculatedValue.clone();
        }
        return null;
    }

    private void prepareForNewCalculation() {
        this.lastCalculatedValue = null;
        this.calculatingSteps = null;
    }

    public final void setSteps(LinkedList<Step> calculationSteps) {
        this.calculatingSteps = calculationSteps;
    }

    public String toString() {
        return InfixParser.toString(this.infix);
    }
}

