/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc.operation;

import java.math.BigDecimal;
import org.jdice.calc.AbstractCalculator;
import org.jdice.calc.Num;
import org.jdice.calc.Operator;
import org.jdice.calc.Properties;
import org.jdice.calc.Rounding;

public class DivOperator
implements Operator {
    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public String getSymbol() {
        return "/";
    }

    @Override
    public Num calc(AbstractCalculator calc, Num value1, Num value2) {
        int scale = Properties.getInheritedScale(calc, value2);
        Rounding roundingMode = Properties.getInheritedRoundingMode(calc, value2);
        return this.calc(value1, value2, scale, roundingMode);
    }

    public Num calc(Num value1, Num value2, Integer scale, Rounding roundingMode) {
        BigDecimal value = value1.toBigDecimal().divide(value2.toBigDecimal(), (int)scale, roundingMode.getBigDecimalRound());
        Num result = new Num(value);
        return result;
    }

    public String toString() {
        return this.getSymbol();
    }
}

