/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.jdice.calc.AbstractCalculator;
import org.jdice.calc.Bracket;
import org.jdice.calc.CList;
import org.jdice.calc.CalculatorException;
import org.jdice.calc.FunctionData;
import org.jdice.calc.Infix;
import org.jdice.calc.Num;
import org.jdice.calc.Operator;
import org.jdice.calc.operation.AddOperator;
import org.jdice.calc.operation.SubOperator;

class Postfix {
    private Stack<Object> stack = new Stack();
    private CList postfix = new CList();
    private int bCount = 0;
    LinkedList<Object> step = null;
    private LinkedList<String> steps = null;

    Postfix() {
    }

    public void toPostfix(CList infix) {
        Iterator<Object> it = infix.iterator();
        while (it.hasNext()) {
            Object current = it.next();
            if (current instanceof Operator || current instanceof Bracket) {
                if (current instanceof Bracket) {
                    Bracket bracket = (Bracket)((Object)current);
                    if (bracket == Bracket.OPEN) {
                        ++this.bCount;
                    } else if (bracket == Bracket.CLOSE) {
                        --this.bCount;
                    }
                }
                int currentPriority = this.getPriority(current);
                if (this.stack.size() == 0) {
                    this.stack.push(current);
                    continue;
                }
                if (this.stack.size() > 0 && Bracket.CLOSE.equals(current)) {
                    while (this.stack.size() > 0 && !Bracket.OPEN.equals(this.stack.peek())) {
                        this.postfix.add((Operator)this.stack.pop());
                    }
                    this.stack.pop();
                    continue;
                }
                if (this.stack.size() <= 0) continue;
                if (Bracket.OPEN.equals(current) && Bracket.OPEN.equals(this.stack.peek()) || !Bracket.OPEN.equals(current) && this.getPriority(this.stack.peek()) >= currentPriority) {
                    while (this.stack.size() > 0 && !Bracket.OPEN.equals(this.stack.peek()) && this.getPriority(this.stack.peek()) >= currentPriority) {
                        Object o = this.stack.pop();
                        if (!(o instanceof Operator)) continue;
                        this.postfix.add((Operator)o);
                    }
                    this.stack.push(current);
                    continue;
                }
                if (this.getPriority(this.stack.peek()) >= currentPriority) continue;
                this.stack.push(current);
                continue;
            }
            if (current instanceof Num) {
                Num calcValue = (Num)current;
                this.postfix.add(calcValue);
                continue;
            }
            if (!(current instanceof FunctionData)) continue;
            FunctionData calcValue = (FunctionData)current;
            this.postfix.add(calcValue);
        }
        this.popAll();
        this.missingBracketDetection(infix);
    }

    private int getPriority(Object input) {
        Bracket inputBracket = input instanceof Bracket ? (Bracket)((Object)input) : null;
        Operator inputOperation = input instanceof Operator ? (Operator)input : null;
        int priority = inputBracket != null ? inputBracket.getPriority() : inputOperation.getPriority();
        return priority;
    }

    private void popAll() {
        Enumeration e = this.stack.elements();
        while (e.hasMoreElements()) {
            Bracket peekBracket;
            Object peek = this.stack.peek();
            Bracket bracket = peekBracket = peek instanceof Bracket ? (Bracket)((Object)peek) : null;
            if (peekBracket != null) {
                this.stack.pop();
                continue;
            }
            this.postfix.add((Operator)this.stack.pop());
        }
    }

    public CList getPostfix() {
        return this.postfix;
    }

    public Num calculate(AbstractCalculator calc, CList postfix) {
        return this.calculate(calc, postfix, false, false);
    }

    public Num calculate(AbstractCalculator calc, CList postfix, boolean trackSteps, boolean showDetails) {
        try {
            return this.calc(calc, postfix, trackSteps, showDetails);
        }
        catch (Exception e) {
            if (!trackSteps) {
                try {
                    this.calc(calc, postfix, true, showDetails);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            StringBuilder sb = new StringBuilder();
            if (this.steps != null) {
                int count = 0;
                int sSize = this.steps.size();
                for (String s : this.steps) {
                    sb.append(s);
                    if (++count >= sSize) {
                        sb.append("  <--- OK\n");
                        continue;
                    }
                    sb.append("\n");
                }
                String es = this.getStep(this.step, showDetails);
                sb.append(es + "  <--- Error: " + e.getMessage());
            }
            throw new CalculatorException("Error during calculation. Check if expression is correct: " + calc.getInfix() + "\n" + sb.toString(), e);
        }
    }

    private Num calc(AbstractCalculator calc, CList postfix, boolean trackSteps, boolean showDetails) {
        if (trackSteps) {
            this.steps = new LinkedList();
        }
        Stack<Object> values = new Stack<Object>();
        Iterator<Object> e = postfix.iterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (o instanceof Num) {
                Num value = (Num)o;
                values.push(value);
                continue;
            }
            if (o instanceof FunctionData) {
                FunctionData function = (FunctionData)o;
                values.push(function);
                continue;
            }
            if (!(o instanceof Operator)) continue;
            if (trackSteps) {
                this.step = new LinkedList();
            }
            Operator operator = (Operator)o;
            Num left = null;
            Num right = null;
            Object oRight = null;
            try {
                oRight = values.pop();
            }
            catch (Exception eR) {
                throw new CalculatorException("Missing right operand");
            }
            Num oLeft = null;
            try {
                oLeft = (Num)values.pop();
            }
            catch (Exception eL) {
                if (operator instanceof SubOperator || operator instanceof AddOperator) {
                    oLeft = new Num(0);
                }
                throw new CalculatorException("Missing operand to the left of the operator '" + operator.getSymbol() + "'");
            }
            if (oLeft instanceof FunctionData) {
                FunctionData fLeft = (FunctionData)((Object)oLeft);
                this.trackStep(this.step, fLeft);
                left = fLeft.calc(calc);
                this.trackStep(this.step, ":", left, null);
            } else {
                left = oLeft;
                this.trackStep(this.step, left);
            }
            this.trackStep(this.step, operator);
            if (oRight instanceof FunctionData) {
                FunctionData fRight = oRight;
                this.trackStep(this.step, fRight);
                right = fRight.calc(calc);
                this.trackStep(this.step, ":", right, null);
            } else {
                right = oRight;
                this.trackStep(this.step, right);
            }
            Num result = null;
            try {
                result = operator.calc(calc, left, right);
            }
            catch (Exception e1) {
                throw new CalculatorException(calc, "Error during calculation.", e1);
            }
            if (result == null) {
                result = new Num();
            }
            this.trackStep(this.step, "\t = ", result, "");
            values.push(result);
            if (this.steps == null) continue;
            this.steps.add(this.getStep(this.step, showDetails));
        }
        Object oResult = values.pop();
        Num result = null;
        if (oResult instanceof Num) {
            result = (Num)oResult;
        } else if (oResult instanceof FunctionData) {
            FunctionData fd = (FunctionData)oResult;
            result = fd.calc(calc);
        }
        if (trackSteps) {
            calc.setSteps(this.steps);
        }
        result.getProperties().load(calc.getProperties());
        return result;
    }

    private String getStep(LinkedList<Object> step, boolean showDetail) {
        StringBuilder sb = new StringBuilder();
        if (step != null) {
            for (Object e : step) {
                if (e instanceof Num) {
                    Num d = (Num)e;
                    if (showDetail) {
                        sb.append(d.toStringWithDetail());
                        continue;
                    }
                    sb.append(d.toString());
                    continue;
                }
                if (e instanceof FunctionData) {
                    FunctionData fd = (FunctionData)e;
                    if (showDetail) {
                        sb.append(fd.toStringWithDetail());
                        continue;
                    }
                    sb.append(fd.toString());
                    continue;
                }
                if (e instanceof Operator) {
                    Operator op = (Operator)e;
                    sb.append("\t" + op.getSymbol() + "  ");
                    continue;
                }
                if (e instanceof String) {
                    String s = (String)e;
                    sb.append(s);
                    continue;
                }
                sb.append(e.toString());
            }
        }
        return sb.toString();
    }

    private void trackStep(LinkedList<Object> step, Object o) {
        this.trackStep(step, null, o, null);
    }

    private void trackStep(LinkedList<Object> step, String before, Object o, String after) {
        if (step != null) {
            if (before != null && before.length() != 0) {
                step.add(before);
            }
            step.add(o);
            if (after != null && after.length() != 0) {
                step.add(after);
            }
        }
    }

    private void missingBracketDetection(CList infix) throws CalculatorException {
        if (this.bCount > 0) {
            throw new CalculatorException("To many open bracket. " + Infix.printInfix(infix));
        }
        if (this.bCount < 0) {
            throw new CalculatorException("To many close bracket. " + Infix.printInfix(infix));
        }
    }
}

