/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.util.HashMap;
import org.jdice.calc.CalculatorException;
import org.jdice.calc.Function;
import org.jdice.calc.Operator;

public class OperationRegister {
    private HashMap<String, Class<? extends Operator>> operatorSymbols = new HashMap();
    private HashMap<Class<? extends Operator>, Operator> operatorCache = new HashMap();
    private HashMap<String, Class<? extends Function>> functionSymbols = new HashMap();
    private HashMap<Class<? extends Function>, Function> functionCache = new HashMap();

    public void registerOperator(Class<? extends Operator> operatorClass) {
        if (!this.operatorSymbols.containsValue(operatorClass) && Operator.class.isAssignableFrom(operatorClass)) {
            Operator operator = this.getOperator(operatorClass);
            this.operatorSymbols.put(operator.getSymbol(), operatorClass);
            this.operatorCache.put(operatorClass, operator);
        }
    }

    public HashMap<String, Class<? extends Operator>> getOperatorSymbols() {
        return this.operatorSymbols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operator getOperator(Class<? extends Operator> operatorClass) {
        Operator operator = null;
        operator = this.operatorCache.get(operatorClass);
        if (operator == null) {
            Class<? extends Operator> clazz = operatorClass;
            synchronized (clazz) {
                operator = this.operatorCache.get(operatorClass);
                if (operator == null) {
                    try {
                        operator = operatorClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new CalculatorException(e);
                    }
                }
            }
        }
        return operator;
    }

    public Operator getOperator(String operator) {
        Operator _operator = null;
        Class<? extends Operator> cl = this.operatorSymbols.get(operator);
        if (cl != null && Operator.class.isAssignableFrom(cl)) {
            _operator = this.getOperator(cl);
        }
        return _operator;
    }

    public void registerFunction(Class<? extends Function> functionClass) {
        if (!this.functionSymbols.containsValue(functionClass) && Function.class.isAssignableFrom(functionClass)) {
            Function function = this.getFunction(functionClass);
            this.functionSymbols.put(function.getSymbol(), functionClass);
            this.functionCache.put(functionClass, function);
        }
    }

    public HashMap<String, Class<? extends Function>> getFunctionSymbols() {
        return this.functionSymbols;
    }

    public Function getFunction(String function) {
        Function _function = null;
        Class<? extends Function> cl = this.functionSymbols.get(function);
        if (cl != null && Function.class.isAssignableFrom(cl)) {
            _function = this.getFunction(cl);
        }
        return _function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(Class<? extends Function> functionClass) {
        Function function = null;
        function = this.functionCache.get(functionClass);
        if (function == null) {
            Class<? extends Function> clazz = functionClass;
            synchronized (clazz) {
                function = this.functionCache.get(functionClass);
                if (function == null) {
                    try {
                        function = functionClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new CalculatorException(e);
                    }
                }
            }
        }
        return function;
    }
}

