/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import org.jdice.calc.AbstractCalculator;
import org.jdice.calc.Cache;
import org.jdice.calc.CalculatorException;
import org.jdice.calc.NumConverter;
import org.jdice.calc.Properties;
import org.jdice.calc.Rounding;

public class Num
implements Cloneable,
Comparable<Num>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Properties properties;
    private Object originalValue;
    private BigDecimal in;
    private BigDecimal out;

    public Num() {
        if (this.in == null) {
            this.setValue(0);
        }
    }

    public Num(Object value) {
        this.setValue(value);
    }

    public Num(String name, Object value) {
        this(value);
        this.name = name;
    }

    public Num(Object value, Class<? extends NumConverter> converter) {
        this.setValue(value, null, converter);
    }

    public Num(String name, Object value, Class<? extends NumConverter> converter) {
        this.name = name;
        this.setValue(value, null, converter);
    }

    public Num(String value) {
        this();
        this.setValue(value);
    }

    public Num(String value, char decimalSeparator) {
        this.setValue(value, Character.valueOf(decimalSeparator));
    }

    public Num(String name, String value, char decimalSeparator) {
        this(value, decimalSeparator);
        this.name = name;
    }

    public Num set(Object value) {
        return this.setValue(value, null);
    }

    public Num set(Object value, Class<? extends NumConverter> converter) {
        return this.setValue(value, null, converter);
    }

    public Num set(String value) {
        return this.setValue(value, null);
    }

    public Num set(String value, char decimalSeparator) {
        return this.setValue(value, Character.valueOf(decimalSeparator));
    }

    private Num setValue(Object value) {
        return this.setValue(value, null);
    }

    private Num setValue(Object value, Character decimalSeparator) {
        return this.setValue(value, decimalSeparator, null);
    }

    private Num setValue(Object value, Character decimalSeparator, Class<? extends NumConverter> converterClass) {
        block19: {
            try {
                this.originalValue = value;
                if (value instanceof Short) {
                    this.in = new BigDecimal(((Short)this.originalValue).shortValue());
                    break block19;
                }
                if (value instanceof Integer) {
                    this.in = new BigDecimal((Integer)this.originalValue);
                    break block19;
                }
                if (value instanceof Long) {
                    this.in = new BigDecimal((Long)this.originalValue);
                    break block19;
                }
                if (value instanceof Float) {
                    this.in = new BigDecimal(((Float)this.originalValue).toString());
                    break block19;
                }
                if (value instanceof Double) {
                    this.in = new BigDecimal(((Double)this.originalValue).toString());
                    break block19;
                }
                if (value instanceof BigInteger) {
                    this.in = new BigDecimal((BigInteger)this.originalValue);
                    break block19;
                }
                if (value instanceof BigDecimal) {
                    this.in = (BigDecimal)this.originalValue;
                    break block19;
                }
                if (value instanceof String) {
                    if (decimalSeparator == null) {
                        decimalSeparator = Character.valueOf(this.getProperties().getInputDecimalSeparator());
                    } else {
                        this.getProperties().setInputDecimalSeparator(decimalSeparator.charValue());
                    }
                    String strValue = (String)value;
                    strValue = Num.stripNumber(strValue, decimalSeparator.charValue());
                    strValue = strValue.replace(decimalSeparator + "", ".");
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                    dfs.setDecimalSeparator('.');
                    DecimalFormat df = new DecimalFormat("#0.0#", dfs);
                    df.setParseBigDecimal(true);
                    this.in = (BigDecimal)df.parse(strValue);
                    break block19;
                }
                if (value instanceof AbstractCalculator) {
                    AbstractCalculator ac = (AbstractCalculator)value;
                    this.originalValue = ac;
                    Num n = ac.calc();
                    this.in = n.toBigDecimal();
                    break block19;
                }
                if (value instanceof Num) {
                    Num tmp = (Num)value;
                    this.setProperties(tmp.getProperties());
                    this.in = tmp.toBigDecimal();
                    break block19;
                }
                if (value == null) {
                    this.originalValue = 0;
                    this.in = new BigDecimal((Integer)this.originalValue);
                    break block19;
                }
                NumConverter nc = null;
                if (converterClass != null && (nc = converterClass.newInstance()) != null && nc.cache()) {
                    Cache.registerNumConverter(value.getClass(), nc);
                }
                if (nc == null) {
                    nc = Cache.getNumConverter(value.getClass());
                }
                if (nc != null) {
                    this.in = nc.toNum(value);
                    break block19;
                }
                throw new CalculatorException("Unsupported type '" + value.getClass() + "'! Supported types are: short, int, long, float, double, Short, Integer, Long, Float, Double, BigInteger, BigDecimal, String");
            }
            catch (ParseException pe) {
                throw new CalculatorException("Parse exception with '" + value + "'", pe);
            }
            catch (Exception e) {
                throw new CalculatorException(e);
            }
        }
        this.out = this.in;
        return this;
    }

    public Num setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public Num setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Num setScale(int scale) {
        this.getProperties().setScale(scale);
        return this;
    }

    public Num setScale(int scale, Rounding roundingMode) {
        this.setScale(scale);
        this.setRoundingMode(roundingMode);
        return this;
    }

    public Integer getScale() {
        return this.getProperties().getScale();
    }

    public Num setRoundingMode(Rounding roundingMode) {
        this.getProperties().setRoundingMode(roundingMode);
        return this;
    }

    public Rounding getRoundingMode() {
        return this.getProperties().getRoundingMode();
    }

    public boolean hasStripTrailingZeros() {
        return this.getProperties().hasStripTrailingZeros();
    }

    public Num setStripTrailingZeros(boolean stripTrailingZeros) {
        this.getProperties().setStripTrailingZeros(stripTrailingZeros);
        return this;
    }

    public Num setOutputFormat(String format) {
        this.getProperties().setOutputFormat(format);
        return this;
    }

    public BigDecimal toBigDecimal() {
        return this.get();
    }

    public BigDecimal get() {
        this.out = this.in;
        if (this.getProperties().getScale() != null) {
            this.out = this.out.setScale((int)this.getProperties().getScale(), this.getProperties().getRoundingMode().getBigDecimalRound());
        }
        if (this.getProperties().hasStripTrailingZeros() && this.hasFraction()) {
            this.out = this.out.stripTrailingZeros();
        }
        return this.out;
    }

    public BigDecimal get(int scale) {
        this.out = this.in.setScale(scale, this.getRoundingMode().getBigDecimalRound());
        if (this.getProperties().hasStripTrailingZeros() && this.hasFraction()) {
            this.out = this.out.stripTrailingZeros();
        }
        return this.out;
    }

    public BigDecimal get(int scale, Rounding roundingMode) {
        this.out = this.in.setScale(scale, this.getRoundingMode().getBigDecimalRound());
        if (this.getProperties().hasStripTrailingZeros() && this.hasFraction()) {
            this.out = this.out.stripTrailingZeros();
        }
        return this.out;
    }

    public BigDecimal getFraction() {
        BigDecimal fraction = this.in.remainder(BigDecimal.ONE);
        return fraction;
    }

    public int getFractionSize() {
        String tmp = this.toString();
        if (tmp.contains(".") && !tmp.endsWith(".")) {
            return tmp.substring(tmp.indexOf(".")).length() - 1;
        }
        return 0;
    }

    public boolean hasFraction() {
        return this.out.toString().contains(".");
    }

    public boolean isZero() {
        return this.out.doubleValue() == 0.0;
    }

    public boolean isNegative() {
        return this.out.doubleValue() < 0.0;
    }

    public <T> T toObject(Class<T> toClass) {
        return (T)this.toObject(toClass, null, null);
    }

    public <T> T toObject(Class<T> toClass, Class<? extends NumConverter> converterClass) {
        return (T)this.toObject(toClass, null, converterClass);
    }

    public <T> T toObject(Class<T> toClass, NumConverter numConverter) {
        return (T)this.toObject(toClass, numConverter, null);
    }

    private Object toObject(Class toClass, NumConverter converter, Class<? extends NumConverter> converterClass) {
        try {
            NumConverter nc = null;
            if (converter != null) {
                nc = converter;
                if (nc.cache()) {
                    Cache.registerNumConverter(toClass, nc);
                }
            } else if (converterClass != null && (nc = converterClass.newInstance()) != null && nc.cache()) {
                Cache.registerNumConverter(toClass, nc);
            }
            if (nc == null) {
                nc = Cache.getNumConverter(toClass);
            }
            if (nc != null) {
                return nc.fromNum(this);
            }
            throw new CalculatorException("Unsupported type '" + toClass + "'! Supported types are: short, int, long, float, double, Short, Integer, Long, Float, Double, BigInteger, BigDecimal, String");
        }
        catch (Exception e) {
            throw new CalculatorException("Unsupported type '" + toClass + "'! Supported types are: short, int, long, float, double, Short, Integer, Long, Float, Double, BigInteger, BigDecimal, String", e);
        }
    }

    public String toStringWithDetail() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.getScale() != null) {
            sb.append("\t scale:" + this.getScale());
        } else {
            sb.append("\t scale: none");
        }
        sb.append("\t" + (Object)((Object)this.getRoundingMode()));
        sb.append("\t strip trailing zeros:" + this.hasStripTrailingZeros());
        sb.append("] : " + this.get());
        return sb.toString();
    }

    public String getFormated() {
        return this.toString(this.getProperties().getGroupingSeparator(), this.getProperties().getOutputDecimalSeparator(), this.getProperties().getOutputFormat());
    }

    public String toString() {
        return this.getFormated();
    }

    public String toString(String format) {
        return this.toString(this.getProperties().getGroupingSeparator(), this.getProperties().getOutputDecimalSeparator(), format);
    }

    public String toString(char decimalSeparator) {
        return this.toString(this.getProperties().getGroupingSeparator(), decimalSeparator, null);
    }

    public String toString(Character groupingSeparator, char decimalSeparator) {
        return this.toString(groupingSeparator, decimalSeparator, this.getProperties().getOutputFormat());
    }

    public String toString(Character groupingSeparator, char decimalSeparator, String format) {
        Integer scale;
        DecimalFormatSymbols custom = new DecimalFormatSymbols();
        custom.setDecimalSeparator(decimalSeparator);
        if (groupingSeparator != null) {
            custom.setGroupingSeparator(groupingSeparator.charValue());
        }
        DecimalFormat decFormat = new DecimalFormat();
        decFormat.setDecimalFormatSymbols(custom);
        if (groupingSeparator == null) {
            decFormat.setGroupingUsed(false);
        }
        if ((scale = this.getScale()) != null) {
            decFormat.setMaximumFractionDigits(scale);
        } else {
            decFormat.setMaximumFractionDigits(64);
        }
        return decFormat.format(this.toBigDecimal());
    }

    public Object getOriginalValue() {
        return this.originalValue;
    }

    public Num clone() {
        Num copy = new Num();
        copy.name = this.name;
        copy.setProperties(this.getProperties());
        copy.originalValue = this.originalValue;
        copy.in = new BigDecimal(this.in.toString());
        copy.set(this.toBigDecimal());
        return copy;
    }

    public int hashCode() {
        return this.toBigDecimal().hashCode();
    }

    public boolean isEqual(String value) {
        return this.isEqual(new Num(value));
    }

    public boolean isEqual(String value, char decimalSeparator) {
        return this.isEqual(new Num(value, decimalSeparator));
    }

    public boolean isEqual(Num value) {
        if (value == null) {
            return false;
        }
        if (this == value) {
            return true;
        }
        Num other = value;
        int i = other.toBigDecimal().compareTo(this.toBigDecimal());
        return i == 0;
    }

    public boolean isEqual(Object value) {
        if (!(value instanceof Num)) {
            Num num = new Num(value);
            return this.isEqual(num);
        }
        return this.isEqual((Num)value);
    }

    public boolean isEqual(Object value, int scale) {
        return this.isEqual(value, scale, null);
    }

    public boolean isEqual(Object value, boolean autoscale) {
        Num numA = this;
        Num numB = null;
        numB = value instanceof Num ? (Num)value : new Num(value);
        int minScale = numA.getFractionSize();
        int bScale = numB.getFractionSize();
        if (bScale < minScale) {
            minScale = bScale;
        }
        return this.isEqual(value, minScale);
    }

    public boolean isEqual(Object value, int scale, Rounding rounding) {
        Num numA = this;
        Num numB = null;
        numB = value instanceof Num ? (Num)value : new Num(value);
        BigDecimal a = numA.toBigDecimal();
        BigDecimal b = numB.toBigDecimal();
        if (rounding != null) {
            a = a.setScale(scale, rounding.getBigDecimalRound());
            b = b.setScale(scale, rounding.getBigDecimalRound());
        } else {
            a = a.setScale(scale, this.getProperties().getRoundingMode().getBigDecimalRound());
            b = b.setScale(scale, this.getProperties().getRoundingMode().getBigDecimalRound());
        }
        return a.equals(b);
    }

    public boolean isEqual(Object value, Class<? extends NumConverter> converter) {
        if (!(value instanceof Num)) {
            Num tmp = new Num(value, converter);
            return this.isEqual(tmp);
        }
        return this.isEqual((Num)value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Num) {
            return this.toBigDecimal().equals(((Num)object).toBigDecimal());
        }
        return false;
    }

    public boolean equals(Num obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.toBigDecimal().equals(obj.toBigDecimal());
    }

    public boolean equals(BigDecimal obj) {
        if (obj == null) {
            return false;
        }
        if (this.toBigDecimal() == obj) {
            return true;
        }
        return this.toBigDecimal().equals(obj);
    }

    @Override
    public int compareTo(Num value2) {
        return this.toBigDecimal().compareTo(value2.toBigDecimal());
    }

    public byte byteValue() {
        return this.toBigDecimal().byteValue();
    }

    public byte byteValueExact() {
        return this.toBigDecimal().byteValueExact();
    }

    public double doubleValue() {
        return this.toBigDecimal().doubleValue();
    }

    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    public int intValue() {
        return this.toBigDecimal().intValue();
    }

    public int intValueExact() {
        return this.toBigDecimal().intValueExact();
    }

    public long longValue() {
        return this.toBigDecimal().longValue();
    }

    public long longValueExact() {
        return this.toBigDecimal().longValueExact();
    }

    public short shortValue() {
        return this.toBigDecimal().shortValue();
    }

    public short shortValueExact() {
        return this.toBigDecimal().shortValueExact();
    }

    public int signum() {
        return this.toBigDecimal().signum();
    }

    public String toEngineeringString() {
        return this.toBigDecimal().toEngineeringString();
    }

    public Num abs() {
        Num abs = new Num(this.toBigDecimal().abs());
        return abs;
    }

    public Num ceil() {
        Num ceil = new Num();
        BigDecimal c = this.toBigDecimal();
        ceil.setValue(c.setScale(0, 2));
        ceil.setProperties(this.getProperties());
        return ceil;
    }

    public Num floor() {
        Num ceil = new Num();
        BigDecimal c = this.toBigDecimal();
        ceil.setValue(c.setScale(0, 3));
        ceil.setProperties(this.getProperties());
        return ceil;
    }

    public static String stripNumber(String value, char decimalSeparator) {
        String regex = "[^0-9" + decimalSeparator + "]";
        if (decimalSeparator == '.') {
            regex = regex.replace(".", "\\.");
        }
        String strip = value.replaceAll(regex, "");
        strip = strip.replace(decimalSeparator + "", ".");
        return strip;
    }

    public static Num toNum(Object object) {
        if (object instanceof Num) {
            return ((Num)object).clone();
        }
        Num n = new Num(object);
        return n;
    }

    public static Num toNum(Object object, Class<? extends NumConverter> converter) {
        if (object instanceof Num) {
            return ((Num)object).clone();
        }
        Num n = new Num(object, converter);
        return n;
    }

    public static Num[] toNums(Object ... object) {
        Num[] values = new Num[object.length];
        for (int i = 0; i < object.length; ++i) {
            values[i] = Num.toNum(object[i]);
        }
        return values;
    }
}

