/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdice.calc.AbstractCalculator;
import org.jdice.calc.Bracket;
import org.jdice.calc.CList;
import org.jdice.calc.Cache;
import org.jdice.calc.Calc;
import org.jdice.calc.CalculatorException;
import org.jdice.calc.Function;
import org.jdice.calc.FunctionData;
import org.jdice.calc.Num;
import org.jdice.calc.OperationRegister;
import org.jdice.calc.Operator;
import org.jdice.calc.Properties;

class Infix {
    private static String REGEX_VARIABLE_NAMES = "([a-zA-Z]+)\\b(?!\\s*\\()";
    private static String REGEX_FUNCTIONS = "[a-zA-Z0-9]+\\(((?<=(?:[(]))[^(].*?(?=[)]))";
    private static Pattern pVariableNames;
    private static Pattern pFunctions;
    private static Pattern pOperations;
    private CList infixList = new CList();
    private OperationRegister registeredOperations;
    private Properties properties;

    public Infix(Properties properties) {
        this.properties = properties;
    }

    public Infix(OperationRegister operationRegister, Properties properties) {
        this.registeredOperations = operationRegister;
        this.properties = properties;
    }

    public static CList parseInfix(OperationRegister operationRegister, Properties properties, String infix, Object ... values) throws ParseException {
        Infix infx = new Infix(operationRegister, properties);
        return infx.parse(infix, values);
    }

    public CList parse(String infix, Object ... values) throws ParseException {
        LinkedHashMap<String, Num> vNames = this.mapValues(infix, values);
        return this.parse(infix, vNames);
    }

    private CList parse(String infix, LinkedHashMap<String, Num> vNames) throws ParseException {
        infix = infix.replace(" ", "");
        int infixLength = infix.length();
        if (pFunctions == null) {
            pFunctions = Pattern.compile(REGEX_FUNCTIONS);
        }
        Matcher mat = pFunctions.matcher(infix);
        int gc = mat.groupCount() + 1;
        int[][] mf = new int[gc + gc + 1][];
        int count = 0;
        int firstIndex = 0;
        int lastIndex = 0;
        while (mat.find()) {
            String group = mat.group();
            if (firstIndex != mat.start()) {
                mf[count++] = new int[]{firstIndex, mat.start(), 0};
            }
            firstIndex = mat.start();
            lastIndex = mat.end() + this.countOccurrences(group, '(');
            mf[count++] = new int[]{firstIndex, lastIndex, 1};
            firstIndex = lastIndex;
        }
        if (lastIndex != infixLength) {
            mf[count++] = new int[]{lastIndex, infixLength, 0};
        }
        for (int i = 0; i < mf.length; ++i) {
            if (mf[i] == null) continue;
            int[] section = mf[i];
            String group = infix.substring(section[0], section[1]);
            if (section[2] == 1) {
                String function = group.substring(0, group.indexOf("("));
                Function op = null;
                if (this.registeredOperations != null) {
                    op = this.registeredOperations.getFunction(function);
                }
                if (op == null) {
                    op = Cache.getFunction(function);
                }
                if (op == null) {
                    throw new CalculatorException("Can't find '" + function + "' function implementation class used in expression " + infix);
                }
                Function f = op;
                String _expression = group.substring(group.indexOf("(") + 1, group.length() - 1);
                String[] expressions = _expression.split(",");
                Object[] values = new Object[expressions.length];
                for (int e = 0; e < expressions.length; ++e) {
                    Infix tmp = new Infix(this.properties);
                    String expression = expressions[e];
                    CList fInfix = tmp.parse(expression, vNames);
                    if (fInfix.size() == 1 && fInfix.get(0) instanceof Num) {
                        Num n = (Num)fInfix.get(0);
                        values[e] = n;
                        continue;
                    }
                    Calc calc = new Calc();
                    calc.setInfix(fInfix);
                    values[e] = calc;
                }
                FunctionData fd = new FunctionData(f, values);
                this.infixList.add(fd);
                continue;
            }
            this.parseInfixString(group, vNames);
        }
        return this.infixList;
    }

    private CList parseInfixString(String infix, LinkedHashMap<String, Num> vNames) throws ParseException {
        String REGEX_NUMBER = this.getRegexNumber();
        if (pOperations == null) {
            String symbol;
            StringBuilder regex = new StringBuilder();
            regex.append(REGEX_NUMBER);
            for (Map.Entry<String, Class<? extends Operator>> op : Cache.getOperatorSymbols().entrySet()) {
                symbol = op.getKey();
                if (".+-*^$?|()".contains(symbol)) {
                    regex.append("|(\\" + symbol + ")");
                    continue;
                }
                regex.append("|(" + symbol + ")");
            }
            if (this.registeredOperations != null) {
                for (Map.Entry<String, Class<? extends Operator>> op : this.registeredOperations.getOperatorSymbols().entrySet()) {
                    symbol = op.getKey();
                    if (".+-*^$?|()".contains(symbol)) {
                        regex.append("|(\\" + symbol + ")");
                        continue;
                    }
                    regex.append("|(" + symbol + ")");
                }
            }
            for (Bracket bracket : Bracket.values()) {
                String symbol2 = bracket.getSymbol();
                if (".+-*^$?|()".contains(symbol2)) {
                    regex.append("|(\\" + symbol2 + ")");
                    continue;
                }
                regex.append("|(" + symbol2 + ")");
            }
            regex.append("|([a-zA-Z]+)");
            pOperations = Pattern.compile(regex.toString());
        }
        boolean hasVariableNames = vNames != null && vNames.size() != 0;
        Matcher mat = pOperations.matcher(infix);
        while (mat.find()) {
            String group = mat.group();
            if (group.matches(REGEX_NUMBER)) {
                Num value = new Num(group);
                this.infixList.add(value);
                continue;
            }
            if (group.matches(Bracket.OPEN.getRegex())) {
                this.infixList.add(Bracket.OPEN);
                continue;
            }
            if (group.matches(Bracket.CLOSE.getRegex())) {
                this.infixList.add(Bracket.CLOSE);
                continue;
            }
            boolean isExists = false;
            Operator op = null;
            if (this.registeredOperations != null) {
                op = this.registeredOperations.getOperator(group);
            }
            if (op == null) {
                op = Cache.getOperator(group);
            }
            if (op != null && op instanceof Operator) {
                this.infixList.add(op);
                isExists = true;
            } else if (hasVariableNames) {
                Num variable = vNames.get(group);
                this.infixList.add(variable);
                isExists = true;
            }
            if (isExists) continue;
            throw new ParseException("Exception while parsing '" + infix + "'. Can't find operation '" + group + "' or " + Num.class.getName() + " with name '" + group + "'", 0);
        }
        return this.infixList;
    }

    public static String printInfix(CList list) {
        return Infix.printInfix(list, false);
    }

    public static String printInfix(CList list, boolean showDetails) {
        StringBuilder sb = new StringBuilder();
        Iterator<Object> it = list.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (value instanceof Operator) {
                Operator op = (Operator)value;
                sb.append(op.getSymbol() + " ");
                continue;
            }
            if (value instanceof FunctionData) {
                FunctionData fd = (FunctionData)value;
                sb.append(fd.getFunction().getSymbol() + "(");
                int count = 0;
                for (Object fObject : fd.getValues()) {
                    Object fValue;
                    if (count++ != 0) {
                        sb.append(", ");
                    }
                    if (fObject instanceof Num) {
                        fValue = (Num)fObject;
                        String name = ((Num)fValue).getName();
                        if (showDetails && name != null && name.length() != 0) {
                            sb.append(name + "[" + ((Num)fValue).get() + "] ");
                            continue;
                        }
                        sb.append(((Num)fValue).get());
                        continue;
                    }
                    if (!(fObject instanceof AbstractCalculator)) continue;
                    fValue = (AbstractCalculator)fObject;
                    try {
                        sb.append(((AbstractCalculator)fValue).getInfix());
                    }
                    catch (Exception e) {
                        sb.append("-error-");
                    }
                }
                sb.append(") ");
                continue;
            }
            if (value instanceof Num) {
                Num cv = (Num)value;
                String name = cv.getName();
                if (showDetails && name != null && name.length() != 0) {
                    sb.append(name + "[" + cv.get() + "] ");
                    continue;
                }
                sb.append(cv.get() + " ");
                continue;
            }
            if (value instanceof Bracket) {
                Bracket bracket = (Bracket)((Object)value);
                sb.append(bracket.getSymbol() + " ");
                continue;
            }
            sb.append("? ");
        }
        return sb.toString().trim();
    }

    private Num findValue(String name, boolean remove, Object ... values) {
        for (int i = 0; i < values.length; ++i) {
            Object o = values[i];
            if (!(o instanceof Num) || !name.equals(((Num)o).getName())) continue;
            if (remove) {
                values[i] = null;
            }
            return (Num)o;
        }
        return null;
    }

    private LinkedHashMap<String, Num> mapValues(String infix, Object ... values) {
        LinkedHashMap<String, Num> vNames = null;
        int remain = 0;
        if (pVariableNames == null) {
            pVariableNames = Pattern.compile(REGEX_VARIABLE_NAMES);
        }
        Matcher mat = pVariableNames.matcher(infix);
        while (mat.find()) {
            String vName;
            if (vNames == null) {
                vNames = new LinkedHashMap<String, Num>();
            }
            if (vNames.containsKey(vName = mat.group())) continue;
            ++remain;
            Num num = this.findValue(vName, true, values);
            vNames.put(vName, num);
            if (num == null) continue;
            --remain;
        }
        if (vNames != null) {
            int lastPos = 0;
            for (Map.Entry entry : vNames.entrySet()) {
                if (entry.getValue() != null) continue;
                for (int i = lastPos; i < values.length; ++i) {
                    Object v = values[i];
                    if (v == null) continue;
                    if (v instanceof Num) {
                        Num n = (Num)v;
                        if (n.getName() == null) {
                            entry.setValue(n);
                        } else if (n.getName().equals(entry.getValue())) {
                            entry.setValue(n);
                        }
                    } else {
                        entry.setValue(Num.toNum(v));
                    }
                    values[i] = null;
                    lastPos = i;
                    --remain;
                }
            }
        }
        if (remain > 0 && vNames != null) {
            StringBuilder sb = new StringBuilder();
            int c = 0;
            for (Map.Entry<String, Num> entry : vNames.entrySet()) {
                if (entry.getValue() != null) continue;
                if (c++ > 0) {
                    sb.append(", ");
                }
                sb.append(entry.getKey());
            }
            throw new CalculatorException("Undefined values for expression (" + infix + ") variables: " + sb.toString());
        }
        return vNames;
    }

    private int countOccurrences(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    private String getRegexNumber() {
        return "([\\d, ]*\\" + this.properties.getInputDecimalSeparator() + "\\d*)|(\\d+)";
    }
}

