/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import org.jdice.calc.AbstractCalculator;
import org.jdice.calc.Cache;
import org.jdice.calc.CalculatorException;
import org.jdice.calc.Function;
import org.jdice.calc.Num;

public class FunctionData {
    private Function function;
    private Object[] values;
    private Num result;

    public FunctionData(Class<? extends Function> function, Object ... values) {
        this.function = Cache.getFunction(function);
        this.setValues(values);
    }

    public FunctionData(Function function, Object ... values) {
        this.function = function;
        this.setValues(values);
    }

    public void setValues(Object ... values) {
        this.values = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object o = values[i];
            this.values[i] = o instanceof AbstractCalculator ? o : Num.toNum(o);
        }
    }

    public Function getFunction() {
        return this.function;
    }

    public Object[] getValues() {
        return this.values;
    }

    public Num getResult() {
        return this.result;
    }

    public Num calc(AbstractCalculator calc) {
        Num[] allValues = new Num[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            Object o = this.values[i];
            if (o instanceof Num) {
                allValues[i] = (Num)o;
                continue;
            }
            if (!(o instanceof AbstractCalculator)) continue;
            AbstractCalculator ac = (AbstractCalculator)o;
            allValues[i] = ac.calc();
        }
        try {
            this.result = this.function.calc(calc, allValues);
        }
        catch (Exception e) {
            throw new CalculatorException(e);
        }
        return this.result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.function.getSymbol());
        sb.append("(");
        for (int i = 0; i < this.values.length; ++i) {
            Object d = this.values[i];
            if (i > 0) {
                sb.append(", ");
            }
            if (d instanceof Num) {
                sb.append(((Num)d).toString());
                continue;
            }
            if (d instanceof AbstractCalculator) {
                try {
                    sb.append(((AbstractCalculator)d).getInfix());
                }
                catch (Exception e) {
                    sb.append("-error-");
                }
                continue;
            }
            sb.append("-unknown-");
        }
        sb.append(")");
        return sb.toString();
    }

    public String toStringWithDetail() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.function.getSymbol());
        sb.append("(");
        for (int i = 0; i < this.values.length; ++i) {
            Object d = this.values[i];
            if (i > 0) {
                sb.append(", ");
            }
            if (d instanceof Num) {
                sb.append(((Num)d).toStringWithDetail());
                continue;
            }
            if (d instanceof AbstractCalculator) {
                try {
                    sb.append(((AbstractCalculator)d).getInfix());
                }
                catch (Exception e) {
                    sb.append("-error-");
                }
                continue;
            }
            sb.append("-unknown-");
        }
        sb.append(")");
        return sb.toString();
    }
}

