/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.text.ParseException;
import org.jdice.calc.AbstractCalculator;
import org.jdice.calc.Num;
import org.jdice.calc.Operator;
import org.jdice.calc.operation.Abs;
import org.jdice.calc.operation.AbsFunction;
import org.jdice.calc.operation.Add;
import org.jdice.calc.operation.AddOperator;
import org.jdice.calc.operation.Div;
import org.jdice.calc.operation.DivOperator;
import org.jdice.calc.operation.Log;
import org.jdice.calc.operation.LogFunction;
import org.jdice.calc.operation.Mod;
import org.jdice.calc.operation.ModOperator;
import org.jdice.calc.operation.Mul;
import org.jdice.calc.operation.MulOperator;
import org.jdice.calc.operation.Pow;
import org.jdice.calc.operation.PowOperator;
import org.jdice.calc.operation.Sqrt;
import org.jdice.calc.operation.SqrtFunction;
import org.jdice.calc.operation.Sub;
import org.jdice.calc.operation.SubOperator;

public class Calc
extends AbstractCalculator<Calc>
implements Add<Calc>,
Sub<Calc>,
Div<Calc>,
Mul<Calc>,
Mod<Calc>,
Pow<Calc>,
Abs<Calc>,
Sqrt<Calc>,
Log<Calc> {
    @Override
    protected Calc getThis() {
        return this;
    }

    public Calc() {
    }

    public Calc(Object value) {
        super(value);
    }

    public Calc(String value) {
        super(value);
    }

    public Calc(String value, char decimalSeparator) {
        super(value, decimalSeparator);
    }

    public Calc(Num value) {
        super(value);
    }

    public static Calc builder() {
        Calc calc = new Calc();
        return calc;
    }

    public static Calc builder(String expression) throws ParseException {
        Calc calc = new Calc();
        calc.parse(expression);
        return calc;
    }

    public static Calc builder(String expression, Object ... values) throws ParseException {
        Calc calc = new Calc();
        calc.parse(expression, values);
        return calc;
    }

    @Override
    public Calc add() {
        return (Calc)this.append(AddOperator.class);
    }

    @Override
    public Calc add(Object value) {
        return (Calc)this.append((Class<? extends Operator>)AddOperator.class, value);
    }

    @Override
    public Calc add(String value) {
        return (Calc)this.append((Class<? extends Operator>)AddOperator.class, (Object)value);
    }

    @Override
    public Calc add(String value, char decimalSeparator) {
        return (Calc)this.append(AddOperator.class, value, decimalSeparator);
    }

    @Override
    public Calc add(Num value) {
        return (Calc)this.append(AddOperator.class, value);
    }

    @Override
    public Calc subtract() {
        return (Calc)this.append(SubOperator.class);
    }

    @Override
    public Calc sub(Object value) {
        return (Calc)this.append((Class<? extends Operator>)SubOperator.class, value);
    }

    @Override
    public Calc sub(String value) {
        return (Calc)this.append((Class<? extends Operator>)SubOperator.class, (Object)value);
    }

    @Override
    public Calc sub(String value, char decimalSeparator) {
        return (Calc)this.append(SubOperator.class, value, decimalSeparator);
    }

    @Override
    public Calc sub(Num value) {
        return (Calc)this.append(SubOperator.class, value);
    }

    @Override
    public Calc divide() {
        return (Calc)this.append(DivOperator.class);
    }

    @Override
    public Calc div(Object value) {
        return (Calc)this.append((Class<? extends Operator>)DivOperator.class, value);
    }

    @Override
    public Calc div(String value) {
        return (Calc)this.append((Class<? extends Operator>)DivOperator.class, (Object)value);
    }

    @Override
    public Calc div(String value, char decimalSeparator) {
        return (Calc)this.append(DivOperator.class, value, decimalSeparator);
    }

    @Override
    public Calc div(Num value) {
        return (Calc)this.append(DivOperator.class, value);
    }

    @Override
    public Calc multiply() {
        return (Calc)this.append(MulOperator.class);
    }

    @Override
    public Calc mul(Object value) {
        return (Calc)this.append((Class<? extends Operator>)MulOperator.class, value);
    }

    @Override
    public Calc mul(String value) {
        return (Calc)this.append((Class<? extends Operator>)MulOperator.class, (Object)value);
    }

    @Override
    public Calc mul(String value, char decimalSeparator) {
        return (Calc)this.append(MulOperator.class, value, decimalSeparator);
    }

    @Override
    public Calc mul(Num value) {
        return (Calc)this.append(MulOperator.class, value);
    }

    @Override
    public Calc power() {
        return (Calc)this.append(PowOperator.class);
    }

    @Override
    public Calc pow(Object value) {
        return (Calc)this.append((Class<? extends Operator>)PowOperator.class, value);
    }

    @Override
    public Calc pow(String value) {
        return (Calc)this.append((Class<? extends Operator>)PowOperator.class, (Object)value);
    }

    @Override
    public Calc pow(String value, char decimalSeparator) {
        return (Calc)this.append(PowOperator.class, value, decimalSeparator);
    }

    @Override
    public Calc pow(Num value) {
        return (Calc)this.append(PowOperator.class, value);
    }

    @Override
    public Calc abs(AbstractCalculator expression) {
        return (Calc)this.append(AbsFunction.class, new Object[]{expression});
    }

    @Override
    public Calc abs(Object value) {
        return (Calc)this.append(AbsFunction.class, new Object[]{new Num(value)});
    }

    @Override
    public Calc abs(String value) {
        return (Calc)this.append(AbsFunction.class, new Object[]{new Num(value)});
    }

    @Override
    public Calc abs(String value, char decimalSeparator) {
        return (Calc)this.append(AbsFunction.class, new Object[]{new Num(value, decimalSeparator)});
    }

    @Override
    public Calc abs(Num value) {
        return (Calc)this.append(AbsFunction.class, new Object[]{value});
    }

    @Override
    public Calc sqrt(AbstractCalculator expression) {
        return (Calc)this.append(SqrtFunction.class, new Object[]{expression});
    }

    @Override
    public Calc sqrt(Object value) {
        return (Calc)this.append(SqrtFunction.class, new Object[]{new Num(value)});
    }

    @Override
    public Calc sqrt(String value) {
        return (Calc)this.append(SqrtFunction.class, new Object[]{new Num(value)});
    }

    @Override
    public Calc sqrt(String value, char decimalSeparator) {
        return (Calc)this.append(SqrtFunction.class, new Object[]{new Num(value, decimalSeparator)});
    }

    @Override
    public Calc sqrt(Num value) {
        return (Calc)this.append(SqrtFunction.class, new Object[]{value});
    }

    @Override
    public Calc modulo() {
        return (Calc)this.append(ModOperator.class);
    }

    @Override
    public Calc mod(Object value) {
        return (Calc)this.append((Class<? extends Operator>)ModOperator.class, value);
    }

    @Override
    public Calc mod(String value) {
        return (Calc)this.append((Class<? extends Operator>)ModOperator.class, (Object)value);
    }

    @Override
    public Calc mod(String value, char decimalSeparator) {
        return (Calc)this.append(ModOperator.class, value, decimalSeparator);
    }

    @Override
    public Calc mod(Num value) {
        return (Calc)this.append(ModOperator.class, value);
    }

    @Override
    public Calc log(AbstractCalculator expression) {
        return (Calc)this.append(LogFunction.class, new Object[]{expression});
    }

    @Override
    public Calc log(Object value) {
        return (Calc)this.append(LogFunction.class, new Object[]{value});
    }

    @Override
    public Calc log(String value) {
        return (Calc)this.append(LogFunction.class, new Object[]{value});
    }

    @Override
    public Calc log(String value, char decimalSeparator) {
        return (Calc)this.append(LogFunction.class, new Object[]{value, Character.valueOf(decimalSeparator)});
    }

    @Override
    public Calc log(Num value) {
        return (Calc)this.append(LogFunction.class, new Object[]{value});
    }
}

