/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jdice.calc.CalculatorException;
import org.jdice.calc.Function;
import org.jdice.calc.NumConverter;
import org.jdice.calc.OperationRegister;
import org.jdice.calc.Operator;
import org.jdice.calc.Properties;

public class Cache {
    private static volatile OperationRegister cacheData = new OperationRegister();
    private static volatile HashMap<Class, NumConverter> converterCache = new HashMap();
    private static volatile boolean numConverterPropLoaded = false;

    public static void registerOperator(Class<? extends Operator> operatorClass) {
        cacheData.registerOperator(operatorClass);
    }

    public static HashMap<String, Class<? extends Operator>> getOperatorSymbols() {
        return cacheData.getOperatorSymbols();
    }

    public static Operator getOperator(Class<? extends Operator> operatorClass) {
        return cacheData.getOperator(operatorClass);
    }

    public static Operator getOperator(String operator) {
        return cacheData.getOperator(operator);
    }

    public static void registerFunction(Class<? extends Function> functionClass) {
        cacheData.registerFunction(functionClass);
    }

    public static HashMap<String, Class<? extends Function>> getFunctionSymbols() {
        return cacheData.getFunctionSymbols();
    }

    public static Function getFunction(String function) {
        return cacheData.getFunction(function);
    }

    public static Function getFunction(Class<? extends Function> functionClass) {
        return cacheData.getFunction(functionClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNumConverter(Class customClass, Class<? extends NumConverter> converterClass) {
        NumConverter nc = converterCache.get(customClass);
        if (nc == null) {
            Class clazz = customClass;
            synchronized (clazz) {
                nc = converterCache.get(customClass);
                if (nc == null) {
                    try {
                        nc = converterClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new CalculatorException(e);
                    }
                    if (nc != null) {
                        converterCache.put(customClass, nc);
                    }
                }
            }
        }
    }

    public static NumConverter registerNumConverter(Class customClass, NumConverter converter) {
        converterCache.put(customClass, converter);
        return converter;
    }

    public static NumConverter getNumConverter(Class<?> customClass) {
        NumConverter nc = converterCache.get(customClass);
        return nc;
    }

    public static NumConverter getNumConverter(Class<?> customClass, Class<? extends NumConverter> convertClass) {
        NumConverter nc;
        if (!numConverterPropLoaded) {
            Cache.loadNumConvertersFromPropertiesFile(null);
        }
        if ((nc = converterCache.get(convertClass)) == null) {
            try {
                nc = convertClass.newInstance();
                if (nc.cache()) {
                    converterCache.put(customClass, nc);
                }
            }
            catch (Exception e) {
                throw new CalculatorException(e);
            }
        }
        return nc;
    }

    public static HashMap<Class, NumConverter> getAllNumConverter() {
        return converterCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadNumConvertersFromPropertiesFile(String absolutePath) {
        File propFile;
        if (absolutePath == null) {
            numConverterPropLoaded = true;
            absolutePath = Properties.getGlobalPropertiesFile();
        }
        if ((propFile = new File(absolutePath)).exists() && propFile.isFile() && propFile.canRead()) {
            java.util.Properties prop = new java.util.Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                prop.load(fis);
                Cache.loadProperties(prop);
            }
            catch (Exception e) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    static void loadProperties(java.util.Properties prop) {
        for (Map.Entry<Object, Object> kv : prop.entrySet()) {
            String[] value;
            Object oValue;
            String key;
            if (!(kv.getKey() instanceof String) || !(key = (String)kv.getKey()).startsWith("calc.numconverter[") || !((oValue = kv.getValue()) instanceof String) || (value = ((String)oValue).split(":")).length != 2) continue;
            try {
                Class<?> customClass = Class.forName(value[0]);
                Class<?> converterClass = Class.forName(value[1]);
                if (!NumConverter.class.isAssignableFrom(converterClass)) continue;
                Cache.registerNumConverter(customClass, converterClass);
            }
            catch (ClassNotFoundException e) {}
        }
    }
}

