/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jdice.calc.Bracket;
import org.jdice.calc.CListListener;
import org.jdice.calc.Cache;
import org.jdice.calc.Function;
import org.jdice.calc.FunctionData;
import org.jdice.calc.Num;
import org.jdice.calc.Operator;

public class CList {
    private LinkedList<Object> list = new LinkedList();
    private CListListener listener;

    public CList() {
    }

    public CList(CListListener listener) {
        this.listener = listener;
    }

    private void change() {
        if (this.listener != null) {
            this.listener.change();
        }
    }

    public boolean add(Bracket bracket) {
        this.change();
        return this.list.add((Object)bracket);
    }

    public boolean add(Operator operator) {
        this.change();
        return this.list.add(operator);
    }

    public boolean add(FunctionData functionData) {
        this.change();
        return this.list.add(functionData);
    }

    public boolean add(Function function) {
        this.change();
        return this.list.add(function);
    }

    public boolean add(Num value) {
        this.change();
        return this.list.add(value);
    }

    public boolean add(Bracket bracket, Num calcValue) {
        this.change();
        boolean isAdded = this.list.add((Object)bracket);
        if (isAdded) {
            isAdded = this.list.add(calcValue);
        }
        return isAdded;
    }

    public boolean add(Class<? extends Operator> operationClass) {
        this.change();
        Operator operationData = Cache.getOperator(operationClass);
        boolean isAdded = this.list.add(operationData);
        return isAdded;
    }

    public boolean addFunction(Class<? extends Function> functionClass, Num ... values) {
        this.change();
        Function function = Cache.getFunction(functionClass);
        boolean isAdded = this.list.add(new FunctionData(function, (Object[])values));
        return isAdded;
    }

    public boolean addFunction(FunctionData functionData) {
        this.change();
        boolean isAdded = this.list.add(functionData);
        return isAdded;
    }

    public boolean add(Class<? extends Operator> operationClass, Num calcValue) {
        this.change();
        Operator operationData = Cache.getOperator(operationClass);
        boolean isAdded = this.list.add(operationData);
        if (isAdded) {
            isAdded = this.list.add(calcValue);
        }
        return isAdded;
    }

    public CList put(Operator operationClass) {
        this.change();
        this.list.add(operationClass);
        return this;
    }

    public CList put(Num calcValue) {
        this.change();
        this.list.add(calcValue);
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(Num o) {
        return this.list.contains(o);
    }

    public boolean contains(Operator operationClass) {
        return this.list.contains(operationClass);
    }

    public Iterator<Object> iterator() {
        return this.list.iterator();
    }

    public Object[] toArray() {
        return this.list.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public void clear() {
        this.list.clear();
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    public Object set(int index, Object element) {
        return this.list.set(index, element);
    }

    public void add(int index, Object element) {
        this.list.add(index, element);
    }

    public Object remove(int index) {
        return this.list.remove(index);
    }

    public ListIterator<Object> listIterator() {
        return this.list.listIterator();
    }

    public ListIterator<Object> listIterator(int index) {
        return this.list.listIterator(index);
    }

    public List<Object> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }
}

