/*
 * Decompiled with CFR 0.152.
 */
package org.jdice.calc;

import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import org.jdice.calc.Bracket;
import org.jdice.calc.CList;
import org.jdice.calc.CListListener;
import org.jdice.calc.Cache;
import org.jdice.calc.CalculatorException;
import org.jdice.calc.Function;
import org.jdice.calc.FunctionData;
import org.jdice.calc.Implementation;
import org.jdice.calc.Infix;
import org.jdice.calc.LinkOperation;
import org.jdice.calc.Num;
import org.jdice.calc.NumConverter;
import org.jdice.calc.Operation;
import org.jdice.calc.OperationRegister;
import org.jdice.calc.Operator;
import org.jdice.calc.Postfix;
import org.jdice.calc.Properties;
import org.jdice.calc.Rounding;

public abstract class AbstractCalculator<CALC> {
    private CList infix = new CList(new CListListener(){

        @Override
        public void change() {
            AbstractCalculator.this.isInfixChanged = true;
        }
    });
    private boolean isInfixChanged = true;
    private CList postfix = new CList();
    private Num lastCalculatedValue;
    private LinkedList<String> calculationSteps;
    private Properties properties;
    private OperationRegister scopeOperationRegister;
    private static boolean isImplOpRegistered = false;
    private AbstractCalculator<CALC> parentCalc;
    private AbstractCalculator<CALC> childCalc;
    private boolean isBind = false;
    private boolean isUnbind = false;

    public AbstractCalculator() {
    }

    private void registerImplmentedOperation() {
        if (!isImplOpRegistered) {
            Class<?>[] declared;
            CALC o = this.getThis();
            Class<?> thisClass = o.getClass();
            for (Class<?> declare : declared = thisClass.getSuperclass().getInterfaces()) {
                this.registerImplmentedOperation(declare);
            }
            for (Class<?> declare : declared = thisClass.getInterfaces()) {
                this.registerImplmentedOperation(declare);
            }
            isImplOpRegistered = true;
        }
    }

    private void registerImplmentedOperation(Class declare) {
        Class<? extends Operation> c = LinkOperation.getOperation(declare);
        if (c == null && declare.isAnnotationPresent(Implementation.class)) {
            Implementation impl = declare.getAnnotation(Implementation.class);
            if (impl != null) {
                c = impl.implementatio();
            }
            LinkOperation.link(declare, c);
        }
        if (c != null) {
            if (Operator.class.isAssignableFrom(c)) {
                Cache.registerOperator(c);
            }
            if (Function.class.isAssignableFrom(c)) {
                Cache.registerFunction(c);
            }
        }
    }

    protected abstract CALC getThis();

    public AbstractCalculator(Object value) {
        Num cValue = new Num();
        cValue.set(value);
        this.infix.add(cValue);
    }

    public AbstractCalculator(Num value) {
        this.infix.add(value);
    }

    public AbstractCalculator(String value) {
        Num cValue = new Num(value);
        this.infix.add(cValue);
    }

    public AbstractCalculator(String value, char decimalSeparator) {
        Num cValue = new Num(value, decimalSeparator);
        this.infix.add(cValue);
    }

    public CALC register(Class<? extends Operation> operationClass) {
        if (this.scopeOperationRegister == null) {
            this.scopeOperationRegister = new OperationRegister();
        }
        if (Operator.class.isAssignableFrom(operationClass)) {
            this.scopeOperationRegister.registerOperator(operationClass.asSubclass(Operator.class));
        }
        if (Function.class.isAssignableFrom(operationClass)) {
            this.scopeOperationRegister.registerFunction(operationClass.asSubclass(Function.class));
        }
        return this.getThis();
    }

    public OperationRegister getRegisteredOperations() {
        return this.scopeOperationRegister;
    }

    public CALC val(short value) {
        this.infix.add(new Num(value));
        return this.getThis();
    }

    public CALC val(int value) {
        this.infix.add(new Num(value));
        return this.getThis();
    }

    public CALC val(long value) {
        this.infix.add(new Num(value));
        return this.getThis();
    }

    public CALC val(float value) {
        this.infix.add(new Num(Float.valueOf(value)));
        return this.getThis();
    }

    public CALC val(double value) {
        this.infix.add(new Num(value));
        return this.getThis();
    }

    public CALC val(Object value) {
        this.infix.add(new Num(value));
        return this.getThis();
    }

    public CALC val(Object value, Class<? extends NumConverter> converter) {
        this.infix.add(new Num(value, converter));
        return this.getThis();
    }

    public CALC val(String value) {
        this.infix.add(new Num(value));
        return this.getThis();
    }

    public CALC val(String value, char decimalSeparator) {
        this.infix.add(new Num(value, decimalSeparator));
        return this.getThis();
    }

    public CALC val(Num value) {
        this.infix.add(value);
        return this.getThis();
    }

    public CALC append(AbstractCalculator expression) {
        return this.append(expression, true);
    }

    public CALC append(AbstractCalculator expression, boolean withinBrackets) {
        this.append(expression.infix, withinBrackets);
        return this.getThis();
    }

    public CALC append(CList infix, boolean withinBrackets) {
        if (withinBrackets) {
            this.infix.add(Bracket.OPEN);
        }
        Iterator<Object> it = infix.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof Num) {
                this.infix.add((Num)o);
                continue;
            }
            if (o instanceof Operator) {
                this.infix.add((Operator)o);
                continue;
            }
            if (o instanceof FunctionData) {
                this.infix.add((FunctionData)o);
                continue;
            }
            if (o instanceof Function) {
                this.infix.add((Function)o);
                continue;
            }
            if (!(o instanceof Bracket)) continue;
            this.infix.add((Bracket)((Object)o));
        }
        if (withinBrackets) {
            this.infix.add(Bracket.CLOSE);
        }
        return this.getThis();
    }

    public CALC append(Class<? extends Operator> operator) {
        this.infix.add(operator);
        return this.getThis();
    }

    public CALC append(Class<? extends Operator> operator, Object value) {
        return this.append(operator, new Num(value));
    }

    public CALC append(Class<? extends Operator> operator, String value, char decimalSeparator) {
        return this.append(operator, new Num(value, decimalSeparator));
    }

    public CALC append(Class<? extends Operator> operator, Num value) {
        this.infix.add(Cache.getOperator(operator));
        this.infix.add(value);
        return this.getThis();
    }

    public CALC append(Class<? extends Function> function, Object ... values) {
        Function fn = Cache.getFunction(function);
        FunctionData fd = new FunctionData(fn, values);
        this.infix.addFunction(fd);
        return this.getThis();
    }

    public CALC parse(String expression) throws ParseException {
        this.registerImplmentedOperation();
        this.append(Infix.parseInfix(this.scopeOperationRegister, this.getProperties(), expression, new Object[0]), false);
        return this.getThis();
    }

    public CALC parse(String expression, Object ... values) throws ParseException {
        this.registerImplmentedOperation();
        this.append(Infix.parseInfix(this.scopeOperationRegister, this.getProperties(), expression, values), false);
        return this.getThis();
    }

    public CALC ob() {
        this.infix.add(Bracket.OPEN);
        return this.getThis();
    }

    public CALC openBracket() {
        this.infix.add(Bracket.OPEN);
        return this.getThis();
    }

    public CALC openBracket(short value) {
        this.infix.add(Bracket.OPEN, new Num(value));
        return this.getThis();
    }

    public CALC openBracket(int value) {
        this.infix.add(Bracket.OPEN, new Num(value));
        return this.getThis();
    }

    public CALC openBracket(long value) {
        this.infix.add(Bracket.OPEN, new Num(value));
        return this.getThis();
    }

    public CALC openBracket(float value) {
        this.infix.add(Bracket.OPEN, new Num(Float.valueOf(value)));
        return this.getThis();
    }

    public CALC openBracket(double value) {
        this.infix.add(Bracket.OPEN, new Num(value));
        return this.getThis();
    }

    public CALC openBracket(Object value) {
        this.infix.add(Bracket.OPEN, new Num(value));
        return this.getThis();
    }

    public CALC openBracket(String value) {
        this.infix.add(Bracket.OPEN, new Num(value));
        return this.getThis();
    }

    public CALC openBracket(String value, char decimalSeparator) {
        this.infix.add(Bracket.OPEN, new Num(value, decimalSeparator));
        return this.getThis();
    }

    public CALC openBracket(Num value) {
        this.infix.add(Bracket.OPEN, value);
        return this.getThis();
    }

    public CALC cb() {
        this.infix.add(Bracket.CLOSE);
        return this.getThis();
    }

    public CALC closeBracket() {
        this.infix.add(Bracket.CLOSE);
        return this.getThis();
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public CALC setProperties(Properties properties) {
        this.properties = properties;
        return this.getThis();
    }

    public CALC setScale(Integer scale) {
        this.getProperties().setScale(scale);
        return this.getThis();
    }

    public Integer getScale() {
        return this.getProperties().getScale();
    }

    public CALC setRoundingMode(Rounding roundingMode) {
        this.getProperties().setRoundingMode(roundingMode);
        return this.getThis();
    }

    public Rounding getRoundingMode() {
        return this.getProperties().getRoundingMode();
    }

    public CALC setDecimalSeparator(char decimalSeparator) {
        this.getProperties().setInputDecimalSeparator(decimalSeparator);
        this.getProperties().setOutputDecimalSeparator(decimalSeparator);
        return this.getThis();
    }

    public char getDecimalSeparator() {
        return this.getProperties().getInputDecimalSeparator();
    }

    public CALC setGroupingSeparator(char decimalSeparator) {
        this.getProperties().setGroupingSeparator(Character.valueOf(decimalSeparator));
        return this.getThis();
    }

    public char getGroupingSeparator() {
        return this.getProperties().getGroupingSeparator().charValue();
    }

    public CALC expression(String expression) throws ParseException {
        this.infix = Infix.parseInfix(this.scopeOperationRegister, this.getProperties(), expression, new Object[0]);
        return this.getThis();
    }

    public CALC expression(String expression, Num ... values) throws ParseException {
        this.infix = Infix.parseInfix(this.scopeOperationRegister, this.getProperties(), expression, values);
        return this.getThis();
    }

    public Num calc() {
        return this.calculate();
    }

    public <T> T calc(Class<T> toClass) {
        Num calc = this.calculate();
        return calc.toObject(toClass);
    }

    public Num calculate() {
        return this.calculate(false, false);
    }

    public Num calcWithSteps(boolean showDetails) {
        return this.calculate(true, showDetails);
    }

    private Num calculate(boolean trackSteps, boolean showDetails) {
        this.unbind();
        this.prepareForNewCalculation();
        Postfix pc = this.convertToPostfix();
        Num cv = pc.calculate(this, this.postfix, trackSteps, showDetails);
        this.lastCalculatedValue = cv.clone();
        return cv;
    }

    public <T extends AbstractCalculator> T bind(Class<T> clazz) {
        AbstractCalculator<CALC> bParent;
        AbstractCalculator childCalc = null;
        try {
            childCalc = (AbstractCalculator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new CalculatorException(e);
        }
        if (childCalc instanceof AbstractCalculator) {
            bParent = this;
            while (bParent != null && bParent.childCalc != null) {
                bParent = bParent.childCalc;
            }
        } else {
            throw new CalculatorException("Use only Calculator class subclases", new IllegalArgumentException());
        }
        childCalc.parentCalc = bParent;
        childCalc.isBind = true;
        bParent.childCalc = childCalc;
        return (T)childCalc;
    }

    private CALC unbind() {
        if (this.childCalc != null) {
            this.unbindAll(this);
        }
        return (CALC)this;
    }

    private CALC unbindAll(AbstractCalculator<CALC> undbindFrom) {
        AbstractCalculator<CALC> tmpParent;
        AbstractCalculator<CALC> root = undbindFrom.parentCalc != null ? undbindFrom.parentCalc : undbindFrom;
        AbstractCalculator<CALC> child = root.childCalc;
        while (root != null && (tmpParent = root.parentCalc) != null) {
            root = tmpParent;
            child = root.childCalc;
        }
        while (child != null) {
            if (!child.isUnbind) {
                root.append(child, false);
            }
            child.isUnbind = true;
            child = child.childCalc;
        }
        return (CALC)undbindFrom;
    }

    public String getPostfix() {
        this.unbind();
        this.convertToPostfix();
        return Infix.printInfix(this.postfix);
    }

    private Postfix convertToPostfix() {
        Postfix pc = new Postfix();
        if (this.postfix == null || this.postfix.size() == 0 || this.isInfixChanged) {
            pc.toPostfix(this.infix);
            this.postfix = pc.getPostfix();
            this.isInfixChanged = false;
        }
        return pc;
    }

    public String getInfix() {
        this.unbind();
        return this.toString();
    }

    CALC setInfix(CList infix) {
        this.infix = infix;
        return this.getThis();
    }

    public boolean isCalculated() {
        return this.lastCalculatedValue != null;
    }

    public Num getCalculated() {
        if (this.lastCalculatedValue != null) {
            return this.lastCalculatedValue.clone();
        }
        return null;
    }

    private void prepareForNewCalculation() {
        this.lastCalculatedValue = null;
        this.calculationSteps = null;
    }

    final void setSteps(LinkedList<String> calculationSteps) {
        this.calculationSteps = calculationSteps;
    }

    public boolean hasCalculationSteps() {
        return this.calculationSteps != null;
    }

    public LinkedList<String> getCalculationSteps() {
        return this.calculationSteps;
    }

    public String toString() {
        return Infix.printInfix(this.infix);
    }
}

