/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.validation;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jdal.ui.Binder;
import org.jdal.ui.bind.PropertyBinder;
import org.jdal.ui.validation.ErrorProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.FieldError;

public class BackgroundErrorProcessor
implements ErrorProcessor {
    private Map<JComponent, Color> colorMap = new HashMap<JComponent, Color>();
    private Color errorColor = new Color(255, 130, 130);
    @Autowired
    private MessageSource messageSource;

    public void processError(Binder<?> binder, FieldError error) {
        if (binder instanceof PropertyBinder) {
            Object o = ((PropertyBinder)binder).getComponent();
            this.processError(o, error);
        }
    }

    public void processError(Object control, FieldError error) {
        if (control instanceof JComponent) {
            JComponent c = (JComponent)control;
            this.colorMap.put(c, c.getBackground());
            c.setBackground(this.errorColor);
            if (this.messageSource != null) {
                c.setToolTipText(this.messageSource.getMessage((MessageSourceResolvable)error, null));
            }
        }
    }

    public void reset() {
        for (JComponent c : this.colorMap.keySet()) {
            c.setBackground(this.colorMap.get(c));
            c.setToolTipText(null);
        }
        this.colorMap.clear();
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(Color errorColor) {
        this.errorColor = errorColor;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

