/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.tree;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.jdal.swing.AbstractView;
import org.jdal.swing.form.FormUtils;
import org.jdal.swing.list.ListComboBoxModel;
import org.jdal.swing.tree.TreeModelBuilder;
import org.jdal.swing.tree.TreeViewModel;

public class TreeView
extends AbstractView<TreeViewModel>
implements ActionListener {
    private JComboBox combo = FormUtils.newCombo(25);
    private JTree tree = new JTree();

    public void init() {
        this.combo.addActionListener(this);
    }

    @Override
    protected JComponent buildPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.add("North", this.combo);
        p.add("Center", new JScrollPane(this.tree));
        return p;
    }

    protected void doRefresh() {
        TreeViewModel model = (TreeViewModel)this.getModel();
        if (model != null) {
            this.combo.setModel(new ListComboBoxModel<TreeModelBuilder>(model.getBuilders()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeModelBuilder b = (TreeModelBuilder)this.combo.getSelectedItem();
        if (b != null) {
            this.tree.setModel(b.build());
        }
    }
}

