/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdal.swing.tree.Node;

public class TreeNodeAdapter
implements MutableTreeNode {
    private Node node;
    private MutableTreeNode parent;

    public TreeNodeAdapter(Node node) {
        this.node = node;
    }

    public Enumeration children() {
        ArrayList<TreeNodeAdapter> list = new ArrayList<TreeNodeAdapter>();
        for (Node n : this.node.getChildren()) {
            list.add(new TreeNodeAdapter(n));
        }
        return Collections.enumeration(list);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        TreeNodeAdapter child = new TreeNodeAdapter(this.node.getChildren().get(childIndex));
        child.setParent(this);
        return child;
    }

    @Override
    public int getChildCount() {
        return this.node.getChildren().size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        int i = 0;
        i = 0;
        while (i < this.node.getChildren().size()) {
            if (this.node.getChildren().get(i).equals(treeNode)) break;
            ++i;
        }
        return i;
    }

    @Override
    public TreeNode getParent() {
        return this.parent != null ? this.parent : (this.node.getParent() != null ? new TreeNodeAdapter(this.node.getParent()) : null);
    }

    @Override
    public boolean isLeaf() {
        return this.node.getChildren().size() == 0;
    }

    public String toString() {
        return this.node.toString();
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void add(Node node) {
        this.node.addChild(node);
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        if (child instanceof TreeNodeAdapter) {
            this.node.addChild(((TreeNodeAdapter)child).getNode());
        }
    }

    @Override
    public void remove(int index) {
        this.node.removeChild(this.node.getChildren().get(index));
    }

    @Override
    public void remove(MutableTreeNode node) {
        if (node instanceof TreeNodeAdapter) {
            this.node.removeChild(((TreeNodeAdapter)node).getNode());
        }
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
            this.parent = null;
        }
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this.parent = newParent;
    }

    @Override
    public void setUserObject(Object object) {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNodeAdapter other = (TreeNodeAdapter)obj;
        return !(this.node == null ? other.node != null : !this.node.equals(other.node));
    }
}

