/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ListTreeNode
implements MutableTreeNode {
    private MutableTreeNode parent;
    private List children = new ArrayList();
    private Object userObject = null;

    public ListTreeNode(String name) {
        this.userObject = name;
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        int i = 0;
        while (i < this.children.size()) {
            if (node != null && node.equals(this.children.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public void add(TreeNode node) {
        this.children.add(node);
    }

    public void remove(TreeNode node) {
        this.children.remove(node);
    }

    public String toString() {
        return this.userObject.toString();
    }

    public List getList() {
        return this.children;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        this.children.add(index, child);
    }

    @Override
    public void remove(int index) {
        this.children.remove(index);
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.children.remove(node);
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this.parent = newParent;
        this.parent.insert(this, newParent.getChildCount());
    }

    @Override
    public void setUserObject(Object object) {
    }
}

