/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.table;

import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdal.dao.Dao;
import org.jdal.logic.CollectionPersistenceService;
import org.jdal.swing.AbstractView;
import org.jdal.swing.GuiFactory;
import org.jdal.swing.ListTableModel;
import org.jdal.swing.PageableTable;
import org.jdal.swing.SimpleDialog;
import org.jdal.swing.table.TablePanel;
import org.springframework.beans.factory.annotation.Autowired;

public class TableListView<T>
extends AbstractView<List<T>> {
    private TablePanel<T> table;
    private CollectionPersistenceService<T, Serializable> dataSource = new CollectionPersistenceService();
    private String tableName;
    @Autowired
    private GuiFactory guiFactory;

    public TableListView() {
        this(new ArrayList());
    }

    public TableListView(List<T> model) {
        super(model);
    }

    public TableListView(String tableName) {
        this();
        this.tableName = tableName;
    }

    public void init() {
        if (this.guiFactory != null && this.tableName != null) {
            this.table = (TablePanel)this.guiFactory.getObject(this.tableName);
            this.table.setPersistentService((Dao<T, Serializable>)this.dataSource);
        }
    }

    @Override
    protected JComponent buildPanel() {
        if (this.table == null) {
            this.buildTable();
        }
        return this.table;
    }

    private void buildTable() {
        this.table = new TablePanel();
        PageableTable pageableTable = new PageableTable();
        ListTableModel ltm = new ListTableModel();
        ltm.setUsingIntrospection(true);
        pageableTable.setTableModel(ltm);
        pageableTable.init();
        this.table.setTable(pageableTable);
        this.table.setPersistentService((Dao<T, Serializable>)this.dataSource);
        this.table.init();
    }

    public void onSetModel(List<T> model) {
        if (model != null && this.table != null) {
            this.dataSource.setCollection(model);
            this.table.getTable().getPaginator().firstPage();
        }
    }

    public static void main(String[] args) {
        TableListView v = new TableListView();
        SimpleDialog dlg = new SimpleDialog(v.getPanel());
        dlg.setSize(new Dimension(1024, 800));
        dlg.setVisible(true);
    }

    public GuiFactory getGuiFactory() {
        return this.guiFactory;
    }

    public void setGuiFactory(GuiFactory guiFactory) {
        this.guiFactory = guiFactory;
    }
}

