/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.table;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdal.swing.TableEditor;
import org.jdal.swing.form.FormUtils;

public class TableEditorFrame
extends JFrame
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_TABLE_ICON = "/images/table/table.png";
    private TableEditor<?>[] editors;
    private JList list = new JList();
    private Icon tableIcon;
    private JPanel editorPanel = new JPanel(new BorderLayout());
    private JSplitPane split;

    public void init() {
        this.tableIcon = FormUtils.getIcon(this.tableIcon, DEFAULT_TABLE_ICON);
        TableEditor<?>[] tableEditorArray = this.editors;
        int n = this.editors.length;
        int n2 = 0;
        while (n2 < n) {
            TableEditor<?> editor = tableEditorArray[n2];
            editor.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
            ++n2;
        }
        this.list = new JList(this.editors);
        this.list.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(-1);
        JScrollPane scroll = new JScrollPane(this.list);
        this.split = new JSplitPane(1, scroll, this.editorPanel);
        this.getContentPane().add(this.split);
        this.list.addListSelectionListener(this);
        this.list.setCellRenderer(new ListCellRenderer());
        this.list.setSelectedIndex(0);
        this.setSize(800, 600);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        TableEditor editor = (TableEditor)this.list.getSelectedValue();
        this.editorPanel.removeAll();
        this.editorPanel.add(editor.getPanel());
        this.split.validate();
    }

    public TableEditor<?>[] getEditors() {
        return this.editors;
    }

    public void setEditors(TableEditor<?>[] editors) {
        this.editors = editors;
    }

    public Icon getTableIcon() {
        return this.tableIcon;
    }

    public void setTableIcon(Icon tableIcon) {
        this.tableIcon = tableIcon;
    }

    class ListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        ListCellRenderer() {
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            super.setIcon(TableEditorFrame.this.tableIcon);
        }
    }
}

