/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.jdal.swing.ListTableModel;
import org.springframework.beans.support.MutableSortDefinition;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.beans.support.SortDefinition;

public class ListTableModelSorter
extends RowSorter<ListTableModel> {
    private ListTableModel model;
    private RowSorter.SortKey key = new RowSorter.SortKey(0, SortOrder.ASCENDING);
    private MutableSortDefinition sortDefinition = new MutableSortDefinition();
    private Comparator comparator = new PropertyComparator((SortDefinition)this.sortDefinition);

    public ListTableModelSorter() {
    }

    public ListTableModelSorter(ListTableModel model) {
        this.model = model;
    }

    @Override
    public ListTableModel getModel() {
        return this.model;
    }

    @Override
    public void toggleSortOrder(int column) {
        this.key = this.key.getColumn() != column ? new RowSorter.SortKey(column, SortOrder.ASCENDING) : new RowSorter.SortKey(column, this.key.getSortOrder() == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING);
        this.sort();
    }

    @Override
    public int convertRowIndexToModel(int index) {
        return index;
    }

    @Override
    public int convertRowIndexToView(int index) {
        return index;
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
        if (!keys.isEmpty()) {
            this.key = keys.get(0);
            this.sort();
        }
    }

    private void sort() {
        String propertyName = this.model.getPropertyName(this.key.getColumn());
        this.sortDefinition.setProperty(propertyName);
        this.sortDefinition.setAscending(SortOrder.ASCENDING.equals((Object)this.key.getSortOrder()));
        Collections.sort(this.model.getList(), this.comparator);
        this.fireSortOrderChanged();
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(1);
        keys.add(this.key);
        return keys;
    }

    @Override
    public int getViewRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public int getModelRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public void modelStructureChanged() {
    }

    @Override
    public void allRowsChanged() {
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow, int column) {
    }
}

