/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.table;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import org.jdal.swing.View;
import org.jdal.swing.form.FormUtils;
import org.jdal.swing.table.TablePanelAction;

public class HideShowFilterAction
extends TablePanelAction {
    public static final String DEFAULT_SHOW_FILTER_ICON = "/images/table/22x22/filter-show.png";
    public static final String DEFAULT_HIDE_FILTER_ICON = "/images/table/22x22/filter-hide.png";
    private static final long serialVersionUID = 1L;
    private Icon showFilterIcon;
    private Icon hideFilterIcon;

    @Override
    public void init() {
        this.showFilterIcon = FormUtils.getIcon(this.showFilterIcon, DEFAULT_SHOW_FILTER_ICON);
        this.hideFilterIcon = FormUtils.getIcon(this.hideFilterIcon, DEFAULT_HIDE_FILTER_ICON);
        this.setIcon(this.hideFilterIcon);
        this.setName(this.messageSource.getMessage("HideShowFilterAction.hideFilter"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        View<Object> filterView = this.getTablePanel().getFilterView();
        if (filterView != null) {
            filterView.getPanel().setVisible(!filterView.getPanel().isVisible());
            String value = filterView.getPanel().isVisible() ? this.messageSource.getMessage("HideShowFilterAction.hideFilter") : this.messageSource.getMessage("HideShowFilterAction.showFilter");
            Icon icon = filterView.getPanel().isVisible() ? this.hideFilterIcon : this.showFilterIcon;
            this.setName(value);
            this.setIcon(icon);
        } else {
            ((JButton)e.getSource()).setEnabled(false);
        }
    }

    public Icon getShowFilterIcon() {
        return this.showFilterIcon;
    }

    public void setShowFilterIcon(Icon showFilterIcon) {
        this.showFilterIcon = showFilterIcon;
    }
}

