/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.report;

import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jdal.dao.filter.ReportFilter;
import org.jdal.logic.PersistentManager;
import org.jdal.reporting.ReportType;
import org.jdal.swing.AbstractView;
import org.jdal.swing.form.BoxFormBuilder;
import org.jdal.swing.form.FormUtils;
import org.jdal.swing.list.ListComboBoxModel;

public class ReportFilterView
extends AbstractView<ReportFilter> {
    private static final int COMBO_WIDTH = 20;
    private JTextField reportName = new JTextField();
    private JComboBox reportType = FormUtils.newCombo(20);
    private PersistentManager<ReportType, Long> reportTypeService;

    public ReportFilterView() {
        this(new ReportFilter());
    }

    public ReportFilterView(ReportFilter reportFilter) {
        this.setModel(reportFilter);
    }

    public void init() {
        this.bind(this.reportName, "name");
        this.bind(this.reportType, "type");
        this.refresh();
    }

    public void doRefresh() {
        List reportTypeList = this.reportTypeService.getAll();
        reportTypeList.add(0, null);
        this.reportType.setModel(new ListComboBoxModel(reportTypeList));
    }

    @Override
    protected JComponent buildPanel() {
        BoxFormBuilder b = new BoxFormBuilder();
        b.add("Nombre: ", this.reportName);
        b.add("Tipo: ", this.reportType);
        JComponent c = b.getForm();
        return c;
    }

    public PersistentManager<ReportType, Long> getReportTypeService() {
        return this.reportTypeService;
    }

    public void setReportTypeService(PersistentManager<ReportType, Long> reportService) {
        this.reportTypeService = reportService;
    }
}

