/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.report;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.sql.DataSource;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.reporting.Report;
import org.jdal.reporting.ReportingException;
import org.jdal.service.ReportService;
import org.jdal.swing.AbstractView;
import org.jdal.swing.report.ReportManager;

public class ReportFileView
extends AbstractView<Report> {
    private static final Log log = LogFactory.getLog(ReportFileView.class);
    private JTextField fileName = new JTextField();
    private Icon addIcon;
    private ReportService reportService;
    private DataSource dataSource;

    public ReportFileView(Report model) {
        this.setModel(model);
    }

    public ReportFileView() {
        this(new Report());
    }

    public void init() {
        this.getPanel();
        this.refresh();
    }

    @Override
    protected JComponent buildPanel() {
        Box box = Box.createHorizontalBox();
        this.fileName.setEditable(false);
        box.add(new JLabel("Fichero"));
        box.add(this.fileName);
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalStrut(5));
        box.add(new JButton(new FileAction()));
        return box;
    }

    private void addAttachment() throws ReportingException {
        Report report = (Report)this.getModel();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new ReportFileFilter());
        if (chooser.showOpenDialog(this.getPanel()) == 0) {
            File file = chooser.getSelectedFile();
            try {
                ((Report)this.getModel()).setData(FileUtils.readFileToByteArray((File)file));
                ((Report)this.getModel()).setFileName(file.getName());
                this.fileName.setText(file.getName());
                FileInputStream reportStream = null;
                try {
                    reportStream = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new ReportingException("Error cargando fichero");
                }
                JasperReport jasperReport = null;
                try {
                    String suffix = ReportManager.getSuffix(file.getName());
                    if (".jrxml".equals(suffix)) {
                        jasperReport = JasperCompileManager.compileReport((InputStream)reportStream);
                    } else if (".jasper".equals(suffix)) {
                        jasperReport = (JasperReport)JRLoader.loadObject((InputStream)reportStream);
                    } else {
                        throw new ReportingException("Archivos del tipo " + suffix + " no pueden ser procesados");
                    }
                    if (jasperReport.getQuery() != null) {
                        report.setHasQuery(new Boolean(true));
                    } else {
                        report.setHasQuery(new Boolean(false));
                    }
                }
                catch (JRException e) {
                    log.error((Object)e);
                    e.printStackTrace();
                    throw new ReportingException("Error procesando fichero");
                }
            }
            catch (IOException e) {
                throw new ReportingException("No se puede leer el Fichero: " + file.getName());
            }
        }
    }

    public Icon getAddIcon() {
        return this.addIcon;
    }

    public void setAddIcon(Icon addIcon) {
        this.addIcon = addIcon;
    }

    public ReportService getService() {
        return this.reportService;
    }

    public void setService(ReportService service) {
        this.reportService = service;
    }

    public JTextField getFileName() {
        return this.fileName;
    }

    public void setFileName(JTextField fileName) {
        this.fileName = fileName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private class FileAction
    extends AbstractAction {
        public FileAction() {
            this.putValue("SmallIcon", ReportFileView.this.addIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ReportFileView.this.addAttachment();
            }
            catch (ReportingException e1) {
                JOptionPane.showMessageDialog(ReportFileView.this.getPanel(), e1.getMessage());
            }
        }
    }

    class ReportFileFilter
    extends FileFilter {
        private String[] allowedFileTypes = new String[]{"jasper", "jrxml"};

        ReportFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String s = file.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                String[] stringArray = this.allowedFileTypes;
                int n = this.allowedFileTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileType = stringArray[n2];
                    if (s.substring(i + 1).toLowerCase().equals(fileType)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            StringBuffer sb = new StringBuffer();
            String[] stringArray = this.allowedFileTypes;
            int n = this.allowedFileTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String fileType = stringArray[n2];
                sb.append(" " + fileType);
                ++n2;
            }
            return sb.toString();
        }
    }
}

