/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.render;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;

public class FileCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    private Map<String, Icon> iconMap = new HashMap<String, Icon>();

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String name = value.toString();
        String extension = name.substring(name.lastIndexOf(46) + 1);
        Icon icon = this.iconMap.get(extension.toLowerCase());
        if (icon == null) {
            icon = this.iconMap.get("default");
        }
        this.setIcon(icon);
        this.setText(name);
        return this;
    }

    public Map<String, Icon> getIconMap() {
        return this.iconMap;
    }

    public void setIconMap(Map<String, Icon> iconMap) {
        this.iconMap = iconMap;
    }
}

