/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.list;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jdal.swing.AbstractView;
import org.jdal.swing.GuiFactory;
import org.jdal.swing.View;
import org.jdal.swing.ViewDialog;
import org.jdal.swing.action.BeanAction;
import org.jdal.swing.form.BoxFormBuilder;
import org.jdal.swing.form.FormUtils;
import org.jdal.swing.list.ListListModel;
import org.springframework.beans.factory.annotation.Autowired;

public class ListView<T>
extends AbstractView<List<T>> {
    private static final String DEFAULT_ADD_ICON = "org/freedesktop/tango/16x16/actions/list-add.png";
    private static final String DEFAULT_REMOVE_ICON = "org/freedesktop/tango/16x16/actions/list-remove.png";
    @Autowired
    private GuiFactory guiFactory;
    private Icon addIcon;
    private Icon removeIcon;
    private JList<T> list = new JList(new ListListModel());
    private ListCellRenderer<T> listCellRenderer;
    private String editor;

    public ListView() {
        super(new ArrayList());
    }

    public void init() {
        this.addIcon = FormUtils.getIcon(this.addIcon, DEFAULT_ADD_ICON);
        this.removeIcon = FormUtils.getIcon(this.removeIcon, DEFAULT_REMOVE_ICON);
        if (this.listCellRenderer != null) {
            this.list.setCellRenderer(this.listCellRenderer);
        }
        this.refresh();
    }

    @Override
    protected JComponent buildPanel() {
        BoxFormBuilder fb = new BoxFormBuilder();
        fb.row();
        fb.startBox();
        fb.setFixedHeight(true);
        fb.row();
        fb.add(new JButton(new AddCommandAction()), 25);
        fb.add(new JButton(new RemoveCommandAction()), 25);
        fb.add(Box.createHorizontalGlue());
        fb.endBox();
        fb.row(Short.MAX_VALUE);
        fb.add(new JScrollPane(this.list));
        return fb.getForm();
    }

    private class AddCommandAction
    extends BeanAction {
        public AddCommandAction() {
            this.setIcon(ListView.this.addIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            View view = (View)ListView.this.guiFactory.getView(ListView.this.editor);
            ViewDialog dlg = new ViewDialog();
            dlg.setView(view);
            dlg.setLocationRelativeTo(ListView.this.getPanel());
            dlg.setModal(true);
            dlg.init();
            dlg.setSize(600, 400);
            dlg.setVisible(true);
            if (dlg.isAccepted()) {
                ListListModel listModel = (ListListModel)ListView.this.list.getModel();
                listModel.add(view.getModel());
            }
        }
    }

    private class RemoveCommandAction
    extends BeanAction {
        public RemoveCommandAction() {
            this.setIcon(ListView.this.removeIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListListModel listModel = (ListListModel)ListView.this.list.getModel();
            listModel.removeAll(ListView.this.list.getSelectedValuesList());
        }
    }
}

