/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;

public class ListListModel<T>
extends AbstractListModel<T> {
    private static final long serialVersionUID = 1L;
    private List<T> list;

    public ListListModel() {
        this(new ArrayList());
    }

    public ListListModel(List<T> list) {
        if (list != null) {
            this.list = list;
        }
    }

    @Override
    public T getElementAt(int index) {
        return this.list.get(index);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
        this.fireContentsChanged(this, -1, -1);
    }

    public void removeAll(Collection<T> c) {
        this.list.removeAll(c);
        this.fireContentsChanged(this, -1, -1);
    }

    public void addAll(Collection<T> c) {
        this.list.addAll(c);
        this.fireContentsChanged(this, -1, -1);
    }

    public void clear() {
        this.list.clear();
        this.fireContentsChanged(this, -1, -1);
    }

    public void add(T item) {
        this.list.add(item);
        this.fireContentsChanged(this, this.getSize() - 1, this.getSize());
    }
}

