/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.list;

import java.util.ArrayList;
import java.util.List;
import javax.swing.MutableComboBoxModel;
import org.apache.commons.lang.ObjectUtils;
import org.jdal.swing.list.ListListModel;

public class ListComboBoxModel<T>
extends ListListModel<T>
implements MutableComboBoxModel<T> {
    private static final long serialVersionUID = 1L;
    private Object selectedItem;
    private boolean allowNullSelection = true;

    public ListComboBoxModel() {
        this(new ArrayList());
    }

    public ListComboBoxModel(List<T> list) {
        this(list, true);
    }

    public ListComboBoxModel(List<T> list, boolean allowNullSelection) {
        super(list);
        if (list != null && list.size() > 0) {
            this.setSelectedItem(list.get(0));
        }
        this.allowNullSelection = allowNullSelection;
    }

    @Override
    public void addElement(T element) {
        this.getList().add(element);
        int index = this.getList().indexOf(element);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void insertElementAt(T element, int index) {
        this.getList().add(index, element);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElement(Object obj) {
        int index = this.getList().indexOf(obj);
        if (this.getList().remove(obj)) {
            this.fireIntervalRemoved(this, index, index);
        }
        if (ObjectUtils.equals((Object)this.selectedItem, (Object)obj)) {
            this.selectedItem = this.getList().size() > 0 ? this.getList().get(0) : null;
        }
    }

    @Override
    public void removeElementAt(int index) {
        this.getList().remove(index);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            this.selectNullItem();
            this.fireContentsChanged(this, -1, -1);
        } else if (!item.equals(this.selectedItem)) {
            int index = this.getList().indexOf(item);
            if (index != -1) {
                this.selectedItem = item;
            } else {
                this.selectNullItem();
            }
            this.fireContentsChanged(this, index, index);
        }
    }

    private void selectNullItem() {
        if (this.allowNullSelection) {
            this.selectedItem = null;
        } else if (this.getList().size() > 0) {
            this.setSelectedItem(this.getList().get(0));
        }
    }
}

