/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormFocusTransversalPolicy
extends FocusTraversalPolicy {
    private static final Log log = LogFactory.getLog(FormFocusTransversalPolicy.class);
    ArrayList<Component> components = new ArrayList();

    @Override
    public Component getComponentAfter(Container container, Component component) {
        int index;
        if (component.getParent() instanceof JComboBox) {
            component = component.getParent();
        }
        if ((index = this.components.indexOf(component)) == -1) {
            Container childContainer = this.getTopmostProvider(container, component);
            if (childContainer == null) {
                return this.getFirstComponent(container);
            }
            FocusTraversalPolicy ftp = childContainer.getFocusTraversalPolicy();
            if (ftp != null && ftp != this) {
                Component next = ftp.getComponentAfter(childContainer, component);
                if (next != ftp.getFirstComponent(container)) {
                    return next;
                }
                do {
                    index = this.components.indexOf(childContainer);
                    childContainer = childContainer.getParent();
                } while (index == -1 || childContainer == null);
                if (index == -1) {
                    log.warn((Object)"I can't figure what is the next component");
                    return this.getFirstComponent(container);
                }
            }
        }
        if (++index < this.components.size() && index >= 0) {
            Component c = this.getComponent(index);
            if (c.isEnabled() && c.isFocusable()) {
                return c;
            }
            return this.getComponentAfter(container, c);
        }
        return this.getFirstComponent(container);
    }

    private Component getComponent(int index) {
        Component c = this.components.get(index);
        Container cc = null;
        if (c instanceof Container) {
            cc = (Container)c;
            if (cc.isFocusTraversalPolicyProvider() || cc.isFocusCycleRoot()) {
                c = cc.getFocusTraversalPolicy().getFirstComponent(cc);
            } else if (cc instanceof JScrollPane && ((JScrollPane)cc).getViewport().getComponentCount() > 0) {
                c = ((JScrollPane)cc).getViewport().getComponent(0);
            }
        }
        return c != null ? c : cc;
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        int index = this.components.indexOf(aComponent);
        if (--index < this.components.size() && index >= 0) {
            Component c = this.getComponent(index);
            if (c.isEnabled()) {
                return c;
            }
            return this.getComponentBefore(aContainer, c);
        }
        return this.getLastComponent(aContainer);
    }

    @Override
    public Component getDefaultComponent(Container aContainer) {
        if (this.components.size() > 0) {
            return this.getComponent(0);
        }
        return null;
    }

    @Override
    public Component getFirstComponent(Container aContainer) {
        return this.getDefaultComponent(aContainer);
    }

    @Override
    public Component getLastComponent(Container aContainer) {
        if (!this.components.isEmpty()) {
            Component c = this.components.get(this.components.size() - 1);
            if (c.isEnabled()) {
                return c;
            }
            return this.getComponentBefore(aContainer, c);
        }
        return null;
    }

    public void add(Component c) {
        this.components.add(c);
    }

    private FocusTraversalPolicy getFocusTraversalPolicyForComponent(Component component) {
        Container c = null;
        while ((c = component.getParent()) != null) {
            if (c.isFocusTraversalPolicyProvider()) {
                return c.getFocusTraversalPolicy();
            }
            component = c;
        }
        return null;
    }

    Container getTopmostProvider(Container focusCycleRoot, Component aComponent) {
        Container aCont = aComponent.getParent();
        Container ftp = null;
        while (aCont != focusCycleRoot && aCont != null) {
            if (aCont.isFocusTraversalPolicyProvider()) {
                ftp = aCont;
            }
            aCont = aCont.getParent();
        }
        if (aCont == null) {
            return null;
        }
        return ftp;
    }
}

