/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.bind;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdal.swing.list.ListListModel;
import org.jdal.ui.bind.AbstractControlAccessor;

public class ListAccessor
extends AbstractControlAccessor
implements ListDataListener,
PropertyChangeListener {
    public ListAccessor(Object list) {
        super(list);
        this.getControl().getModel().addListDataListener(this);
        this.getControl().addPropertyChangeListener(this);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.fireControlChange();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.fireControlChange();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.fireControlChange();
    }

    public Collection<?> getControlValue() {
        ArrayList l = new ArrayList();
        ListModel lm = this.getControl().getModel();
        int i = 0;
        while (i < lm.getSize()) {
            l.add(lm.getElementAt(i));
            ++i;
        }
        return l;
    }

    public void setControlValue(Object value) {
        ListListModel<Object> listModel = null;
        if (value instanceof Collection) {
            listModel = new ListListModel(new ArrayList((Collection)value));
        } else if (value instanceof Object[]) {
            listModel = new ListListModel<Object>(Arrays.asList((Object[])value));
        }
        if (listModel != null) {
            listModel.addListDataListener(this);
            this.getControl().setModel(listModel);
        }
    }

    public JList getControl() {
        return (JList)super.getControl();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            this.fireControlChange();
        }
    }
}

