/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.bind;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.swing.ModelHolder;
import org.jdal.swing.bind.UndefinedAccessorException;
import org.jdal.ui.Binder;
import org.jdal.ui.bind.ConfigurableControlAccessorFactory;
import org.jdal.ui.bind.ControlAccessor;
import org.jdal.ui.bind.ControlAccessorFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultBindingErrorProcessor;

public class AutoBinder<T>
implements Binder<T> {
    private static final Log log = LogFactory.getLog(AutoBinder.class);
    private Object view;
    private ControlAccessorFactory controlAccessorFactory;
    private ConfigurablePropertyAccessor viewPropertyAccessor;
    private BeanWrapper modelPropertyAccessor;
    private Set<String> ignoredProperties = new HashSet<String>();
    private T model;
    private RefreshCommand refreshCommand = new RefreshCommand();
    private UpdateCommand updateCommand = new UpdateCommand();
    private BindingErrorProcessor errorProcessor = new DefaultBindingErrorProcessor();
    private BindingResult bindingResult;
    private Map<String, ControlAccessor> controlAccessorMap = new HashMap<String, ControlAccessor>();

    public AutoBinder(ModelHolder<T> view) {
        this(view, view.getModel());
    }

    public AutoBinder(Object view, T model) {
        this.view = view;
        this.model = model;
        this.viewPropertyAccessor = new DirectFieldAccessor(this.view);
        this.bindingResult = new BeanPropertyBindingResult(model, "model");
    }

    public void bind(String viewField, String propertyName) throws UndefinedAccessorException {
        Object control = this.viewPropertyAccessor.getPropertyValue(propertyName);
        if (control != null) {
            ControlAccessor accessor = this.controlAccessorFactory.getControlAccessor(control);
            if (accessor != null) {
                this.controlAccessorMap.put(propertyName, accessor);
            } else {
                String msg = "Not found ControlAcessor for control class [" + control.getClass().getName() + "]";
                throw new UndefinedAccessorException(msg);
            }
        }
    }

    public void refresh() {
        this.executeBinderCommand(this.refreshCommand);
    }

    public void update() {
        this.executeBinderCommand(this.updateCommand);
    }

    private void executeBinderCommand(BinderCommand command) {
        this.modelPropertyAccessor = PropertyAccessorFactory.forBeanPropertyAccess(this.model);
        PropertyDescriptor[] propertyDescriptorArray = this.modelPropertyAccessor.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ControlAccessor controlAccessor;
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            String propertyName = pd.getName();
            if (!this.ignoredProperties.contains(propertyName) && (controlAccessor = this.getControlAccessor(propertyName)) != null) {
                command.execute(controlAccessor, propertyName);
            }
            ++n2;
        }
    }

    private ControlAccessor getControlAccessor(String name) {
        Object control;
        if (this.controlAccessorMap.containsKey(name)) {
            return this.controlAccessorMap.get(name);
        }
        ControlAccessor accessor = null;
        if (this.viewPropertyAccessor.isReadableProperty(name) && (control = this.viewPropertyAccessor.getPropertyValue(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found control: " + control.getClass().getSimpleName() + " for property: " + name));
            }
            accessor = this.getControlAccessorFactory().getControlAccessor(control);
        }
        return accessor;
    }

    public T getModel() {
        return this.model;
    }

    public void setModel(T model) {
        this.model = model;
    }

    public ControlAccessorFactory getControlAccessorFactory() {
        if (this.controlAccessorFactory == null) {
            this.controlAccessorFactory = new ConfigurableControlAccessorFactory();
        }
        return this.controlAccessorFactory;
    }

    public void setControlAccessorFactory(ControlAccessorFactory controlAccessorFactory) {
        this.controlAccessorFactory = controlAccessorFactory;
    }

    public void ignoreProperty(String propertyName) {
        this.ignoredProperties.add(propertyName);
    }

    public Set<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public void setIgnoredProperties(Set<String> ignoredProperties) {
        this.ignoredProperties = ignoredProperties;
    }

    public void ignoreProperties(Collection<? extends String> c) {
        this.ignoredProperties.addAll(c);
    }

    public BindingResult getBindingResult() {
        return this.bindingResult;
    }

    static interface BinderCommand {
        public void execute(ControlAccessor var1, String var2);
    }

    class RefreshCommand
    implements BinderCommand {
        RefreshCommand() {
        }

        @Override
        public void execute(ControlAccessor controlAccessor, String name) {
            controlAccessor.setControlValue(AutoBinder.this.modelPropertyAccessor.getPropertyValue(name));
        }
    }

    class UpdateCommand
    implements BinderCommand {
        UpdateCommand() {
        }

        @Override
        public void execute(ControlAccessor controlAccessor, String name) {
            try {
                AutoBinder.this.modelPropertyAccessor.setPropertyValue(name, controlAccessor.getControlValue());
            }
            catch (PropertyAccessException pae) {
                AutoBinder.this.errorProcessor.processPropertyAccessException(pae, AutoBinder.this.bindingResult);
            }
        }
    }
}

