/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.bind;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.persistence.ManyToOne;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.annotations.Reference;
import org.jdal.swing.list.ListComboBoxModel;
import org.jdal.swing.list.ListListModel;
import org.jdal.ui.bind.ControlInitializerSupport;
import org.jdal.ui.bind.InitializationConfig;
import org.jdal.util.BeanUtils;

public class AnnotationControlInitializer
extends ControlInitializerSupport {
    private static final Log log = LogFactory.getLog(AnnotationControlInitializer.class);

    public void initialize(Object control, String property, InitializationConfig config) {
        Annotation[] annotations;
        if (this.dao == null) {
            log.warn((Object)"Nothing to do without persistent service");
            return;
        }
        Class clazz = config.getType();
        Class propertyType = BeanUtils.getPropertyDescriptor((Class)clazz, (String)property).getPropertyType();
        Annotation[] annotationArray = annotations = this.getAnnotations(property, clazz);
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (ManyToOne.class.equals(a.annotationType())) {
                List entities = this.getEntityList(propertyType, config.getSortPropertyName());
                this.sort(entities, control);
                if (control instanceof JComboBox) {
                    ((JComboBox)control).setModel(new ListComboBoxModel(entities));
                    break;
                }
                if (!(control instanceof JList)) break;
                ((JList)control).setModel(new ListListModel(entities));
                break;
            }
            if (Reference.class.equals(a.annotationType()) && control instanceof JComboBox) {
                Reference r = (Reference)a;
                Class type = Void.TYPE.equals(r.target()) ? propertyType : r.target();
                List entities = this.getEntityList(type, config.getSortPropertyName());
                List values = StringUtils.isEmpty((String)r.property()) ? entities : this.getValueList(entities, r.property());
                ((JComboBox)control).setModel(new ListComboBoxModel(values));
                break;
            }
            ++n2;
        }
    }

    private void sort(List<Object> entities, Object control) {
    }
}

