/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.action;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.JOptionPane;
import org.jdal.dao.Dao;
import org.jdal.service.PersistentServiceAware;
import org.jdal.swing.View;
import org.jdal.swing.ViewDialog;
import org.jdal.swing.action.ViewAction;
import org.jdal.swing.form.FormUtils;
import org.jdal.ui.Editor;

public class ViewSaveAction<T>
extends ViewAction<T>
implements PersistentServiceAware<T> {
    private static final String DEFAULT_ICON = "/images/16x16/dialog-ok.png";
    private static final String DEFAULT_NAME = "Accept";
    private Dao<T, ? extends Serializable> service;

    public ViewSaveAction() {
        this.setIcon(FormUtils.getIcon(DEFAULT_ICON));
        this.setName(DEFAULT_NAME);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.beforeSave();
        this.afterSave(this.save());
    }

    private boolean save() {
        View view = this.getView();
        view.update();
        boolean valid = view.validateView();
        if (valid) {
            if (this.service != null) {
                this.service.save(view.getModel());
            }
            this.getDialog().setVisible(false);
            this.getDialog().dispose();
            if (this.getDialog() instanceof ViewDialog) {
                ((ViewDialog)this.getDialog()).setValue(0);
            }
            if (this.getDialog() instanceof Editor) {
                ((Editor)this.getDialog()).save();
            }
        } else if (this.onError()) {
            String errorMessage = view.getErrorMessage();
            JOptionPane.showMessageDialog(view.getPanel(), errorMessage, "Error", 0);
        }
        return valid;
    }

    protected boolean onError() {
        return true;
    }

    protected void afterSave(boolean valid) {
    }

    protected void beforeSave() {
    }

    @Deprecated
    public Dao<T, ? extends Serializable> getService() {
        return this.service;
    }

    @Deprecated
    public void setService(Dao<T, ? extends Serializable> service) {
        this.service = service;
    }

    public void setPersistentService(Dao<T, ? extends Serializable> persistentService) {
        this.service = persistentService;
    }
}

