/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.action;

import java.util.List;
import javax.swing.JComboBox;
import org.jdal.dao.Dao;
import org.jdal.dao.Page;
import org.jdal.dao.filter.PatternFilter;
import org.jdal.swing.action.AutoCompletionListener;

public class FilterAutoCompletionListener
extends AutoCompletionListener {
    public static final String DEFAULT_SORT_PROPERTY = "name";
    private Dao persistentService;
    private int maxResults = Short.MAX_VALUE;
    private String sortProperty;

    public FilterAutoCompletionListener() {
    }

    public FilterAutoCompletionListener(JComboBox combo) {
        this(combo, Short.MAX_VALUE);
    }

    public FilterAutoCompletionListener(JComboBox combo, int maxValue) {
        this(combo, Short.MAX_VALUE, DEFAULT_SORT_PROPERTY);
    }

    public FilterAutoCompletionListener(JComboBox combo, int maxResults, String sortProperty) {
        super(combo);
        this.maxResults = maxResults;
        this.sortProperty = sortProperty;
    }

    protected List getList(String editing) {
        Page page = new Page(this.maxResults);
        PatternFilter filter = new PatternFilter();
        filter.setPattern(String.valueOf(editing.trim()) + "%");
        page.setFilter((Object)filter);
        return this.persistentService.getPage(page).getData();
    }

    public Dao getPersistentService() {
        return this.persistentService;
    }

    public void setPersistentService(Dao persistentService) {
        this.persistentService = persistentService;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public String getSortProperty() {
        return this.sortProperty;
    }

    public void setSortProperty(String sortProperty) {
        this.sortProperty = sortProperty;
    }
}

