/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing.action;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public abstract class AutoCompletionListener
extends KeyAdapter {
    private JComboBox combo;

    public AutoCompletionListener() {
    }

    public AutoCompletionListener(JComboBox combo) {
        this.listenOn(combo);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char ch = e.getKeyChar();
        if (ch == '\uffff' || Character.isISOControl(ch)) {
            return;
        }
        ComboBoxEditor editor = this.combo.getEditor();
        String editing = ((JTextField)editor.getEditorComponent()).getText();
        this.combo.removeAllItems();
        this.addList(this.getList(editing));
        this.combo.setPopupVisible(true);
        ((JTextField)editor.getEditorComponent()).setText(editing);
        this.combo.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        if (ch == '\uffff' || Character.isISOControl(ch)) {
            return;
        }
        if (this.combo.getSelectedItem() != null) {
            this.combo.setSelectedItem(null);
            this.combo.getEditor().setItem(null);
        }
    }

    public void listenOn(JComboBox combo) {
        if (this.combo != null) {
            this.combo.getEditor().getEditorComponent().removeKeyListener(this);
        }
        this.combo = combo;
        combo.setEditable(true);
        combo.getEditor().getEditorComponent().addKeyListener(this);
    }

    private void addList(List<?> list) {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(list.toArray());
        model.setSelectedItem(null);
        this.combo.setModel(model);
    }

    protected abstract List<?> getList(String var1);

    public JComboBox getCombo() {
        return this.combo;
    }

    public void setCombo(JComboBox combo) {
        this.combo = combo;
    }
}

