/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.swing.ColumnDescriptor;
import org.jdal.swing.VisibilityItem;

class VisibilityBox
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VisibilityBox.class);
    List<ColumnDescriptor> columnDescriptors;

    public VisibilityBox(List<ColumnDescriptor> columnDescriptors) {
        this.setColumnDescriptors(columnDescriptors);
        this.setLayout(new BoxLayout(this, 3));
        for (ColumnDescriptor cd : this.columnDescriptors) {
            this.add(new VisibilityItem(cd));
        }
    }

    public void refresh() {
        int i = 0;
        while (i < this.getComponents().length) {
            Component c = this.getComponent(i);
            if (c instanceof VisibilityItem) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("refresh: " + this.columnDescriptors.get(i).isVisible()));
                }
                ((VisibilityItem)c).setColumnDescriptor(this.columnDescriptors.get(i));
            }
            ++i;
        }
    }

    public List<ColumnDescriptor> getColumnDescriptors() {
        return this.columnDescriptors;
    }

    public void setColumnDescriptors(List<ColumnDescriptor> columnDescriptors) {
        this.columnDescriptors = new ArrayList<ColumnDescriptor>(columnDescriptors.size());
        for (ColumnDescriptor cd : columnDescriptors) {
            this.columnDescriptors.add((ColumnDescriptor)cd.clone());
        }
        this.refresh();
    }
}

