/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.apache.commons.lang.StringUtils;
import org.jdal.dao.Dao;
import org.jdal.service.PersistentServiceAware;
import org.jdal.swing.View;
import org.jdal.swing.action.DialogAcceptAction;
import org.jdal.swing.action.ViewAction;
import org.jdal.swing.action.ViewCancelAction;
import org.jdal.ui.Editor;
import org.jdal.ui.EditorEvent;
import org.jdal.ui.EditorListener;
import org.jdal.ui.bind.ControlChangeListener;
import org.springframework.validation.BindingResult;

public class ViewFrame<T>
extends JFrame
implements View<T>,
Editor<T> {
    private static final long serialVersionUID = 1L;
    private View<T> view;
    private ViewAction<T> acceptAction = new DialogAcceptAction();
    private ViewAction<T> cancelAction = new ViewCancelAction();
    private JButton acceptButton;
    private JButton cancelButton;
    private int windowWidth;
    private int windowHeight;
    private EventListenerList listenerList = new EventListenerList();
    private Dao<T, ? extends Serializable> persistentService;

    public ViewFrame() {
    }

    public ViewFrame(Frame owner) {
    }

    public void init() {
        this.acceptAction.setView(this.view);
        this.cancelAction.setView(this.view);
        this.acceptAction.setDialog(this);
        this.cancelAction.setDialog(this);
        this.add((Component)this.view.getPanel(), "Center");
        this.add(this.createButtonBox(), "South");
        if (this.view.getModel() != null && StringUtils.isEmpty((String)this.getTitle())) {
            this.setTitle(this.view.getModel().toString());
        }
        this.setLocationRelativeTo(null);
        this.setSize(new Dimension(this.windowWidth, this.windowHeight));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new CloseListener());
    }

    protected Component createButtonBox() {
        this.acceptButton = new JButton(this.acceptAction);
        this.cancelButton = new JButton(this.cancelAction);
        JPanel p = new JPanel();
        p.add(this.acceptButton);
        p.add(this.cancelButton);
        return p;
    }

    public void save() {
        Object[] listeners = this.listenerList.getListenerList();
        EditorEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == EditorListener.class) {
                if (e == null) {
                    e = new EditorEvent((Object)this, this.getModel());
                }
                ((EditorListener)listeners[i + 1]).modelChanged(e);
            }
            i -= 2;
        }
    }

    public View<T> getView() {
        return this.view;
    }

    public void setView(View<T> view) {
        this.view = view;
    }

    public ViewAction<T> getAcceptAction() {
        return this.acceptAction;
    }

    public void setAcceptAction(ViewAction<T> acceptAction) {
        this.acceptAction = acceptAction;
        this.acceptAction.setView(this.view);
        this.acceptAction.setDialog(this);
    }

    public ViewAction<T> getCancelAction() {
        return this.cancelAction;
    }

    public void setCancelAction(ViewAction<T> cancelAction) {
        this.cancelAction = cancelAction;
        cancelAction.setDialog(this);
        cancelAction.setView(this.view);
    }

    public T getModel() {
        return (T)this.view.getModel();
    }

    @Override
    public JComponent getPanel() {
        return this.view.getPanel();
    }

    public void refresh() {
        this.view.refresh();
        this.setTitle(this.view.getModel().toString());
    }

    public void setModel(T model) {
        this.view.setModel(model);
    }

    public void update() {
        this.view.update();
    }

    public void clear() {
        this.view.clear();
    }

    public boolean validateView() {
        return this.view.validateView();
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(int windowWidth) {
        this.windowWidth = windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowHeight(int windowHeight) {
        this.windowHeight = windowHeight;
    }

    public void addEditorListener(EditorListener l) {
        this.listenerList.add(EditorListener.class, l);
    }

    public void removeEditorListener(EditorListener l) {
        this.listenerList.remove(EditorListener.class, l);
    }

    public boolean isDirty() {
        return this.view.isDirty();
    }

    public void enableView(boolean enabled) {
        this.view.enableView(enabled);
    }

    public BindingResult getBindingResult() {
        return this.view.getBindingResult();
    }

    public String getErrorMessage() {
        return this.view.getErrorMessage();
    }

    public void addControlChangeListener(ControlChangeListener listener) {
        this.view.addControlChangeListener(listener);
    }

    public void removeControlChangeListener(ControlChangeListener listener) {
        this.view.removeControlChangeListener(listener);
    }

    public void setPersistentService(Dao<T, ? extends Serializable> persistentService) {
        this.persistentService = persistentService;
        if (this.acceptAction instanceof PersistentServiceAware) {
            ((PersistentServiceAware)this.acceptAction).setPersistentService(this.persistentService);
        }
    }

    public void cancel() {
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ViewFrame.this.cancelAction.actionPerformed(null);
        }
    }
}

