/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdal.dao.PageChangedEvent;
import org.jdal.dao.Paginator;
import org.jdal.dao.PaginatorListener;
import org.jdal.swing.AbstractView;
import org.jdal.swing.DefaultPaginator;
import org.jdal.swing.form.FormUtils;

public class PaginatorView
extends AbstractView<Paginator>
implements PaginatorListener {
    private static final String DEFAULT_NEXT_ICON = "images/table/22x22/go-next.png";
    private static final String DEFAULT_PREVIOUS_ICON = "images/table/22x22/go-previous.png";
    private static final String DEFAULT_LAST_ICON = "images/table/22x22/go-last.png";
    private static final String DEFAULT_FIRST_ICON = "images/table/22x22/go-first.png";
    private Paginator paginator;
    private JComboBox pageSizeCombo;
    private JButton nextPageButton;
    private JButton previousPageButton;
    private JButton lastPageButton;
    private JButton firstPageButton;
    private String[] pageSizes = new String[]{"10", "25", "50", "100", "All"};
    private JLabel statusLabel;
    private JLabel countLabel;
    private Icon nextIcon;
    private Icon previousIcon;
    private Icon lastIcon;
    private Icon firstIcon;

    public PaginatorView() {
        this(new DefaultPaginator());
    }

    public PaginatorView(Paginator paginator) {
        this.paginator = paginator;
        paginator.addPaginatorListener((PaginatorListener)this);
    }

    public void init() {
        this.nextIcon = FormUtils.getIcon(this.nextIcon, DEFAULT_NEXT_ICON);
        this.previousIcon = FormUtils.getIcon(this.previousIcon, DEFAULT_PREVIOUS_ICON);
        this.lastIcon = FormUtils.getIcon(this.lastIcon, DEFAULT_LAST_ICON);
        this.firstIcon = FormUtils.getIcon(this.firstIcon, DEFAULT_FIRST_ICON);
    }

    @Override
    protected JComponent buildPanel() {
        this.pageSizeCombo = new JComboBox<String>(this.pageSizes);
        this.pageSizeCombo.addItemListener(new PageSizeComboListener());
        this.nextPageButton = new JButton(new NextPageAction());
        this.previousPageButton = new JButton(new PreviousPageAction());
        this.lastPageButton = new JButton(new LastPageAction());
        this.firstPageButton = new JButton(new FirstPageAction());
        this.statusLabel = new JLabel();
        this.countLabel = new JLabel();
        JLabel numberPagesLabel = new JLabel(String.valueOf(this.getMessage("PaginatorView.pageSize")) + " ");
        this.pageSizeCombo.setMaximumSize(new Dimension(70, 30));
        numberPagesLabel.setAlignmentX(1.0f);
        Box box = Box.createHorizontalBox();
        box.setBackground(Color.LIGHT_GRAY);
        box.setOpaque(true);
        box.add(this.countLabel);
        box.add(Box.createHorizontalStrut(100));
        box.add(Box.createHorizontalGlue());
        box.add(this.firstPageButton);
        box.add(this.previousPageButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.statusLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.nextPageButton);
        box.add(this.lastPageButton);
        box.add(Box.createHorizontalGlue());
        box.add(numberPagesLabel);
        box.add(this.pageSizeCombo);
        box.add(Box.createHorizontalStrut(30));
        String pageSize = (String)this.pageSizeCombo.getSelectedItem();
        this.paginator.setPageSize(this.parsePageSize(pageSize));
        return box;
    }

    public void pageChanged(PageChangedEvent event) {
        this.refresh();
    }

    public void doRefresh() {
        this.statusLabel.setText(this.paginator.getPage() + " / " + this.paginator.getTotalPages());
        this.countLabel.setText(String.valueOf(this.getMessage("PaginatorView.records")) + " " + this.paginator.getCount());
        boolean hasNext = this.paginator.hasNext();
        boolean hasPrevious = this.paginator.hasPrevious();
        this.nextPageButton.setEnabled(hasNext);
        this.lastPageButton.setEnabled(hasNext);
        this.previousPageButton.setEnabled(hasPrevious);
        this.firstPageButton.setEnabled(hasPrevious);
        if (Integer.MAX_VALUE == this.paginator.getPageSize()) {
            this.pageSizeCombo.setSelectedIndex(this.pageSizeCombo.getItemCount() - 1);
        } else {
            this.pageSizeCombo.setSelectedItem(String.valueOf(this.paginator.getPageSize()));
        }
    }

    public void doUpdate() {
        this.paginator.setPageSize(this.parsePageSize((String)this.pageSizeCombo.getSelectedItem()));
    }

    public Icon getNextIcon() {
        return this.nextIcon;
    }

    public void setNextIcon(Icon nextIcon) {
        this.nextIcon = nextIcon;
    }

    public Icon getPreviousIcon() {
        return this.previousIcon;
    }

    public void setPreviousIcon(Icon previousIcon) {
        this.previousIcon = previousIcon;
    }

    public Icon getLastIcon() {
        return this.lastIcon;
    }

    public void setLastIcon(Icon lastIcon) {
        this.lastIcon = lastIcon;
    }

    public Icon getFirstIcon() {
        return this.firstIcon;
    }

    public void setFirstIcon(Icon firstIcon) {
        this.firstIcon = firstIcon;
    }

    public String[] getPageSizes() {
        return this.pageSizes;
    }

    public void setPageSizes(String[] pageSizes) {
        this.pageSizes = pageSizes;
    }

    public Paginator getPaginator() {
        return this.paginator;
    }

    public void setPaginator(Paginator paginator) {
        if (paginator != null) {
            paginator.removePaginatorListener((PaginatorListener)this);
        }
        this.paginator = paginator;
        paginator.addPaginatorListener((PaginatorListener)this);
    }

    private int parsePageSize(String item) {
        int pageSize;
        try {
            pageSize = Integer.parseInt(item.trim());
        }
        catch (NumberFormatException nfe) {
            pageSize = Integer.MAX_VALUE;
        }
        return pageSize;
    }

    class FirstPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FirstPageAction() {
            this.putValue("SmallIcon", PaginatorView.this.firstIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaginatorView.this.paginator.firstPage();
        }
    }

    class LastPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LastPageAction() {
            this.putValue("SmallIcon", PaginatorView.this.lastIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaginatorView.this.paginator.lastPage();
        }
    }

    class NextPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NextPageAction() {
            this.putValue("SmallIcon", PaginatorView.this.nextIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaginatorView.this.paginator.nextPage();
        }
    }

    class PageSizeComboListener
    implements ItemListener {
        PageSizeComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            String item = (String)e.getItem();
            int pageSize = PaginatorView.this.parsePageSize(item);
            if (PaginatorView.this.paginator.getPageSize() != pageSize) {
                PaginatorView.this.paginator.setPageSize(pageSize);
            }
        }
    }

    class PreviousPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public PreviousPageAction() {
            this.putValue("SmallIcon", PaginatorView.this.previousIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaginatorView.this.paginator.previousPage();
        }
    }
}

