/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.beans.MessageSourceWrapper;
import org.jdal.dao.Dao;
import org.jdal.dao.Page;
import org.jdal.dao.PageChangedEvent;
import org.jdal.dao.PageableDataSource;
import org.jdal.dao.Paginator;
import org.jdal.dao.PaginatorListener;
import org.jdal.model.TableState;
import org.jdal.service.TableService;
import org.jdal.swing.ColumnDescriptor;
import org.jdal.swing.GuiFactory;
import org.jdal.swing.ListTableModel;
import org.jdal.swing.ModelRowSorter;
import org.jdal.swing.PaginatorView;
import org.jdal.swing.TableRowAction;
import org.jdal.swing.View;
import org.jdal.swing.VisibilityBox;
import org.jdal.swing.form.FormUtils;
import org.jdal.swing.table.LoadPreferencesAction;
import org.jdal.swing.table.SavePreferencesAction;
import org.jdal.ui.Editor;
import org.jdal.ui.EditorEvent;
import org.jdal.ui.EditorListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

public class PageableTable<T>
extends JPanel
implements RowSorterListener,
PaginatorListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PageableTable.class);
    private BorderLayout layout = new BorderLayout();
    private JTable table;
    private PaginatorView paginatorView;
    private Page<T> page = new Page();
    private PageableDataSource<T> dataSource;
    private ListTableModel tableModel;
    private JScrollPane tableScrollPane;
    private ModelRowSorter<ListTableModel> sorter;
    private List<ColumnDescriptor> columnDescriptors;
    private VisibilityBox visibilityBox;
    private GuiFactory guiFactory;
    private String editorName;
    private Map<Object, Window> openDialogs = Collections.synchronizedMap(new HashMap());
    private TableService tableService;
    private MessageSourceWrapper messageSource = new MessageSourceWrapper();
    private boolean showMenu = true;
    private boolean showPaginator = true;
    private ArrayList<ChangeListener> changeListeners = new ArrayList();
    private ArrayList<EditorListener> editorListeners = new ArrayList();
    private boolean configureEditors = true;
    JMenuBar rightMenuBar;
    private Icon visibilityMenuIcon;
    private Icon okIcon;
    private Icon cancelIcon;
    private Icon userMenuIcon;
    private String sortPropertyName;
    private Page.Order order;

    public void init() {
        this.okIcon = FormUtils.getIcon(this.okIcon, "/images/16x16/dialog-ok.png");
        this.cancelIcon = FormUtils.getIcon(this.cancelIcon, "/images/16x16/dialog-cancel.png");
        this.visibilityMenuIcon = FormUtils.getIcon(this.visibilityMenuIcon, "/images/16x16/view-choose.png");
        this.userMenuIcon = FormUtils.getIcon(this.userMenuIcon, "/images/table/16x16/users.png");
        if (this.tableModel == null) {
            this.tableModel = new ListTableModel();
        }
        this.setLayout(this.layout);
        this.sorter = new ModelRowSorter<ListTableModel>(this.tableModel);
        this.sorter.addRowSorterListener(this);
        if (this.showPaginator) {
            if (this.paginatorView == null) {
                this.paginatorView = new PaginatorView();
                this.paginatorView.init();
            }
            this.paginatorView.setPaginator((Paginator)this.page);
            this.page.addPaginatorListener((PaginatorListener)this);
            this.add((Component)this.paginatorView.getPanel(), "South");
        } else {
            this.page.setPageSize(Integer.MAX_VALUE);
        }
        this.createColumnDescriptos();
        this.table = new JTable(this.tableModel, this.tableModel.getTableColumnModel());
        this.table.setAutoCreateRowSorter(false);
        this.table.setRowSorter(this.sorter);
        this.table.setRowHeight(22);
        this.table.addMouseListener(new TableListener());
        this.tableScrollPane = new JScrollPane(this.table);
        this.setBackground(Color.WHITE);
        this.add((Component)this.tableScrollPane, "Center");
        if (this.showMenu) {
            this.createMenu();
        }
        this.page.setPageableDataSource(this.dataSource);
        this.page.firstPage();
        this.restoreState();
    }

    private void createMenu() {
        this.rightMenuBar = new JMenuBar();
        this.rightMenuBar.setLayout(new BoxLayout(this.rightMenuBar, 3));
        this.rightMenuBar.setMargin(new Insets(0, 0, 0, 0));
        JMenu menu = new JMenu();
        menu.setMargin(new Insets(0, 0, 0, 0));
        menu.setIcon(this.visibilityMenuIcon);
        menu.setMaximumSize(new Dimension(50, 50));
        this.visibilityBox = new VisibilityBox(this.columnDescriptors);
        menu.add(this.visibilityBox);
        menu.getPopupMenu().addPopupMenuListener(new VisibilityPopupListener());
        JMenuItem okMenuItem = new JMenuItem(new OkVisibilityAction());
        JMenuItem cancelMenuItem = new JMenuItem(new CancelVisibilityAction());
        menu.addSeparator();
        menu.add(okMenuItem);
        menu.add(cancelMenuItem);
        this.rightMenuBar.add(menu);
        JMenu prefsMenu = new JMenu();
        prefsMenu.setMargin(new Insets(0, 0, 0, 0));
        prefsMenu.setIcon(this.userMenuIcon);
        prefsMenu.setMaximumSize(new Dimension(50, 50));
        prefsMenu.add(new JMenuItem(new LoadPreferencesAction(this, this.messageSource.getMessage("PageableTable.loadPreferences", null, "Load Preferences", Locale.getDefault()))));
        prefsMenu.add(new JMenuItem(new SavePreferencesAction(this, this.messageSource.getMessage("PageableTable.savePreferences", null, "Save Preferences", Locale.getDefault()))));
        this.rightMenuBar.add(prefsMenu);
        this.rightMenuBar.add(Box.createVerticalGlue());
        this.add((Component)this.rightMenuBar, "East");
    }

    private void createColumnDescriptos() {
        this.columnDescriptors = new ArrayList<ColumnDescriptor>(this.tableModel.getPropertyCount());
        int i = 0;
        while (i < this.tableModel.getPropertyCount()) {
            this.columnDescriptors.add(new ColumnDescriptor(this.tableModel.getColumnNames().get(i), this.tableModel.getDisplayNames().get(i), true));
            ++i;
        }
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        if (this.sorter.getSortKeys().size() > 0 && this.tableModel.isPropertyColumn(this.sorter.getSortKeys().get(0).getColumn())) {
            this.configurePage();
            this.page.firstPage();
        }
    }

    private Page.Order converSortOrder(RowSorter.SortKey key) {
        Page.Order order = Page.Order.ASC;
        if (key.getSortOrder() == SortOrder.DESCENDING) {
            order = Page.Order.DESC;
        }
        return order;
    }

    private void configurePage() {
        RowSorter.SortKey key;
        Page.Order order = Page.Order.ASC;
        String sortPropertyName = null;
        List<RowSorter.SortKey> keys = this.sorter.getSortKeys();
        if (keys.size() > 0 && this.tableModel.isPropertyColumn((key = this.sorter.getSortKeys().get(0)).getColumn())) {
            sortPropertyName = this.tableModel.getSortPropertyName(key.getColumn());
            order = this.converSortOrder(key);
        }
        this.page.setSortName(sortPropertyName);
        this.page.setOrder(order);
    }

    public void pageChanged(PageChangedEvent event) {
        this.tableModel.setList(this.page.getData());
        this.fireChangeEvent();
    }

    public Window getEditor() {
        if (this.editorName == null) {
            return null;
        }
        Window owner = SwingUtilities.getWindowAncestor(this);
        Window window = owner instanceof Frame ? (Window)this.guiFactory.getObject(this.editorName, new Object[]{owner}) : (Window)this.guiFactory.getObject(this.editorName);
        if (window instanceof Editor) {
            Editor editor = (Editor)window;
            if (this.dataSource instanceof Dao && this.configureEditors) {
                editor.setPersistentService((Dao)this.dataSource);
            }
            for (EditorListener listener : this.editorListeners) {
                editor.addEditorListener(listener);
            }
        }
        return window;
    }

    public Window getEditor(Object toEdit) {
        Window dlg = this.openDialogs.get(toEdit);
        if (dlg == null) {
            dlg = this.getEditor();
            if (dlg == null) {
                return null;
            }
            this.openDialogs.put(toEdit, dlg);
            ((View)((Object)dlg)).setModel(toEdit);
            ((View)((Object)dlg)).refresh();
            dlg.addWindowListener(new DialogWindowListener());
            if (dlg instanceof Editor) {
                Editor editor = (Editor)dlg;
                editor.addEditorListener(new EditorListener(){

                    public void modelChanged(EditorEvent e) {
                        PageableTable.this.refresh();
                    }
                });
            }
        }
        ((View)((Object)dlg)).refresh();
        return dlg;
    }

    public void restoreState() {
        TableState state;
        if (this.tableService != null && (state = this.tableService.getState(this.getName())) != null) {
            this.restoreState(state);
        }
    }

    public void restoreState(TableState state) {
        for (ColumnDescriptor cd : this.columnDescriptors) {
            cd.setVisible(state.getVisibleColumns().contains(cd.getPropertyName()));
        }
        this.updateVisibleColumns();
        if (this.paginatorView != null) {
            this.getPaginator().setPageSize(state.getPageSize());
        }
    }

    private void updateVisibleColumns() {
        ArrayList<String> displayNames = new ArrayList<String>(this.columnDescriptors.size());
        ArrayList<String> propertyNames = new ArrayList<String>(this.columnDescriptors.size());
        for (ColumnDescriptor cd : this.columnDescriptors) {
            if (!cd.isVisible()) continue;
            displayNames.add(cd.getDisplayName());
            propertyNames.add(cd.getPropertyName());
        }
        this.tableModel.setDisplayNames(displayNames);
        this.tableModel.setColumnNames(propertyNames);
        this.tableModel.init();
        this.table.setColumnModel(this.tableModel.getTableColumnModel());
        this.tableModel.fireTableChanged();
    }

    public void saveState() {
        if (this.tableService == null) {
            return;
        }
        TableState state = new TableState();
        ArrayList<String> visible = new ArrayList<String>();
        for (ColumnDescriptor cd : this.columnDescriptors) {
            if (!cd.isVisible()) continue;
            visible.add(cd.getPropertyName());
        }
        state.setName(this.getName());
        state.setVisibleColumns(visible);
        state.setPageSize(this.paginatorView.getPaginator().getPageSize());
        this.tableService.saveState(state);
    }

    public void addChangeListener(ChangeListener l) {
        if (!this.changeListeners.contains(l)) {
            this.changeListeners.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    private void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }

    public PaginatorView getPaginatorView() {
        return this.paginatorView;
    }

    public void setPaginatorView(PaginatorView paginatorView) {
        this.paginatorView = paginatorView;
    }

    public PageableDataSource<T> getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(PageableDataSource<T> dataSource) {
        this.dataSource = dataSource;
        this.page.setPageableDataSource(dataSource);
    }

    public Paginator getPaginator() {
        return this.paginatorView.getPaginator();
    }

    public ListTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(ListTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public Icon getVisibilityMenuIcon() {
        return this.visibilityMenuIcon;
    }

    public void setVisibilityMenuIcon(Icon visibilityMenuIcon) {
        this.visibilityMenuIcon = visibilityMenuIcon;
    }

    public Icon getOkIcon() {
        return this.okIcon;
    }

    public void setOkIcon(Icon okIcon) {
        this.okIcon = okIcon;
    }

    public Icon getCancelIcon() {
        return this.cancelIcon;
    }

    public void setCancelIcon(Icon cancelIcon) {
        this.cancelIcon = cancelIcon;
    }

    public GuiFactory getGuiFactory() {
        return this.guiFactory;
    }

    public void setGuiFactory(GuiFactory guiFactory) {
        this.guiFactory = guiFactory;
    }

    public String getEditorName() {
        return this.editorName;
    }

    public void setEditorName(String editorName) {
        this.editorName = editorName;
    }

    public void refresh() {
        this.page.setPage(this.page.getPage());
    }

    public Object getFilter() {
        return this.page.getFilter();
    }

    public void setFilter(Object filter) {
        this.page.setFilter(filter);
    }

    public void setDefaultRenderer(Class<?> columnClass, TableCellRenderer renderer) {
        this.table.setDefaultRenderer(columnClass, renderer);
    }

    public String getSortPropertyName() {
        return this.sortPropertyName;
    }

    public void setSortPropertyName(String sortPropertyName) {
        this.sortPropertyName = sortPropertyName;
    }

    public Page.Order getOrder() {
        return this.order;
    }

    public void setOrder(Page.Order order) {
        this.order = order;
    }

    public TableService getTableService() {
        return this.tableService;
    }

    public void setTableService(TableService tableService) {
        this.tableService = tableService;
    }

    public Icon getUserMenuIcon() {
        return this.userMenuIcon;
    }

    public void setUserMenuIcon(Icon userMenuIcon) {
        this.userMenuIcon = userMenuIcon;
    }

    public MessageSource getMessageSource() {
        return this.messageSource.getMessageSource();
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource.setMessageSource(messageSource);
    }

    public boolean isShowMenu() {
        return this.showMenu;
    }

    public void setShowMenu(boolean showMenu) {
        this.showMenu = showMenu;
    }

    public List<Serializable> getChecked() {
        return this.tableModel.getChecked();
    }

    public List<T> getVisibleSelected() {
        return this.tableModel.getVisibleChecked();
    }

    public void selectAll() {
        Page page = new Page(Integer.MAX_VALUE);
        page.setFilter(this.page.getFilter());
        this.tableModel.check(this.dataSource.getKeys(page));
    }

    public void unSelectAll() {
        this.tableModel.uncheckAll();
    }

    public boolean isConfigureEditors() {
        return this.configureEditors;
    }

    public void setConfigureEditors(boolean configureEditors) {
        this.configureEditors = configureEditors;
    }

    public void addEditorListener(EditorListener listener) {
        if (!this.editorListeners.contains(listener)) {
            this.editorListeners.add(listener);
        }
    }

    public void removeEditorListener(EditorListener listener) {
        this.editorListeners.remove(listener);
    }

    public boolean isShowPaginator() {
        return this.showPaginator;
    }

    public void setShowPaginator(boolean showPaginator) {
        this.showPaginator = showPaginator;
    }

    public int getPageSize() {
        return this.page.getPageSize();
    }

    public void setPageSize(int pageSize) {
        this.page.setPageSize(pageSize);
    }

    class CancelVisibilityAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CancelVisibilityAction() {
            super(PageableTable.this.messageSource.getMessage("Cancel"), PageableTable.this.cancelIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageableTable.this.visibilityBox.setColumnDescriptors(PageableTable.this.columnDescriptors);
        }
    }

    private class DialogWindowListener
    extends WindowAdapter {
        private DialogWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (PageableTable.this.openDialogs.remove(((View)((Object)e.getWindow())).getModel()) == null) {
                log.warn((Object)"Tray to remove a non existant Dialog, \u00bfmay be model hashcode changed?");
            }
        }
    }

    class OkVisibilityAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public OkVisibilityAction() {
            super(PageableTable.this.messageSource.getMessage("Accept"), PageableTable.this.okIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = 0;
            while (i < PageableTable.this.columnDescriptors.size()) {
                ColumnDescriptor cd = (ColumnDescriptor)PageableTable.this.columnDescriptors.get(i);
                cd.setVisible(PageableTable.this.visibilityBox.getColumnDescriptors().get(i).isVisible());
                ++i;
            }
            PageableTable.this.updateVisibleColumns();
        }
    }

    private class TableListener
    extends MouseAdapter {
        private TableListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object toEdit;
            Window dlg;
            Point point = e.getPoint();
            int row = PageableTable.this.table.rowAtPoint(point);
            int col = PageableTable.this.table.columnAtPoint(point);
            if (col != -1 && row != -1 && PageableTable.this.tableModel.isActionColumn(col)) {
                TableRowAction action = (TableRowAction)PageableTable.this.tableModel.getValueAt(row, col);
                action.setTable(PageableTable.this);
                action.setRow(PageableTable.this.tableModel.getList().get(row));
                action.actionPerformed(new ActionEvent(this, 1001, "clicked"));
            }
            if (row != -1 && e.getClickCount() == 2 && (dlg = PageableTable.this.getEditor(toEdit = PageableTable.this.tableModel.getList().get(row))) != null) {
                if (dlg instanceof Frame) {
                    ((Frame)dlg).setState(0);
                    ((Frame)dlg).requestFocus();
                }
                dlg.setLocationRelativeTo(null);
                dlg.setVisible(true);
            }
        }
    }

    class VisibilityPopupListener
    implements PopupMenuListener {
        VisibilityPopupListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            PageableTable.this.visibilityBox.setColumnDescriptors(PageableTable.this.columnDescriptors);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            PageableTable.this.visibilityBox.setColumnDescriptors(PageableTable.this.columnDescriptors);
        }
    }
}

